/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.security.B64Code;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.UserIdentity;

public class ClientCertAuthenticator
extends LoginAuthenticator {
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        try {
            char[] credential;
            String username;
            UserIdentity user;
            if (certs == null || certs.length == 0 || certs[0] == null) {
                response.sendError(403, "A client certificate is required for accessing this web application but the server's listener is not configured for mutual authentication (or the client did not provide a certificate).");
                return DefaultAuthentication.SEND_FAILURE_RESULTS;
            }
            Principal principal = certs[0].getSubjectDN();
            if (principal == null) {
                principal = certs[0].getIssuerDN();
            }
            if ((user = this._loginService.login(username = principal == null ? "clientcert" : principal.getName(), credential = B64Code.encode((byte[])certs[0].getSignature()))) != null) {
                return new DefaultAuthentication(Authentication.Status.SUCCESS, "CLIENT-CERT", user);
            }
            if (!mandatory) {
                return DefaultAuthentication.SUCCESS_UNAUTH_RESULTS;
            }
            response.sendError(403, "The provided client certificate does not correspond to a trusted user.");
            return DefaultAuthentication.SEND_FAILURE_RESULTS;
        }
        catch (IOException e) {
            throw new ServerAuthException(e.getMessage());
        }
    }

    public Authentication.Status secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication validatedUser) throws ServerAuthException {
        return Authentication.Status.SUCCESS;
    }
}

