/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.security.MessageDigest;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.security.B64Code;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;

public class DigestAuthenticator
extends LoginAuthenticator {
    protected long _maxNonceAge = 0L;
    protected long _nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean _useStale = false;

    public String getAuthMethod() {
        return "DIGEST";
    }

    public Authentication.Status secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication validatedUser) throws ServerAuthException {
        return Authentication.Status.SUCCESS;
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            boolean stale = false;
            if (credentials != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Credentials: " + credentials));
                }
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
                Digest digest = new Digest(request.getMethod());
                String last = null;
                String name = null;
                block7: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            name = last;
                            last = tok;
                            continue block7;
                        }
                        case ',': {
                            name = null;
                        }
                        case ' ': {
                            continue block7;
                        }
                    }
                    last = tok;
                    if (name == null) continue;
                    if ("username".equalsIgnoreCase(name)) {
                        digest.username = tok;
                        continue;
                    }
                    if ("realm".equalsIgnoreCase(name)) {
                        digest.realm = tok;
                        continue;
                    }
                    if ("nonce".equalsIgnoreCase(name)) {
                        digest.nonce = tok;
                        continue;
                    }
                    if ("nc".equalsIgnoreCase(name)) {
                        digest.nc = tok;
                        continue;
                    }
                    if ("cnonce".equalsIgnoreCase(name)) {
                        digest.cnonce = tok;
                        continue;
                    }
                    if ("qop".equalsIgnoreCase(name)) {
                        digest.qop = tok;
                        continue;
                    }
                    if ("uri".equalsIgnoreCase(name)) {
                        digest.uri = tok;
                        continue;
                    }
                    if (!"response".equalsIgnoreCase(name)) continue;
                    digest.response = tok;
                }
                int n = this.checkNonce(digest.nonce, (Request)request);
                if (n > 0) {
                    UserIdentity user = this._loginService.login(digest.username, (Object)digest);
                    if (user != null) {
                        if (user instanceof DefaultUserIdentity) {
                            return ((DefaultUserIdentity)user).SUCCESSFUL_BASIC;
                        }
                        return new DefaultAuthentication(Authentication.Status.SUCCESS, "DIGEST", user);
                    }
                } else if (n == 0) {
                    stale = true;
                }
            }
            if (!mandatory) {
                return DefaultAuthentication.SUCCESS_UNAUTH_RESULTS;
            }
            String domain = request.getContextPath();
            if (domain == null) {
                domain = "/";
            }
            response.setHeader("WWW-Authenticate", "Digest realm=\"" + this._loginService.getName() + "\", domain=\"" + domain + "\", nonce=\"" + this.newNonce((Request)request) + "\", algorithm=MD5, qop=\"auth\"" + (this._useStale ? " stale=" + stale : ""));
            response.sendError(401);
            return DefaultAuthentication.SEND_CONTINUE_RESULTS;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    public String newNonce(Request request) {
        long ts = request.getTimeStamp();
        long sk = this._nonceSecret;
        byte[] nounce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nounce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
        for (int i = 0; i < hash.length; ++i) {
            nounce[8 + i] = hash[i];
            if (i == 23) break;
        }
        return new String(B64Code.encode((byte[])nounce));
    }

    private int checkNonce(String nonce, Request request) {
        try {
            byte[] n = B64Code.decode((char[])nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this._nonceSecret;
            byte[] n2 = new byte[16];
            System.arraycopy(n, 0, n2, 0, 8);
            for (int i = 0; i < 8; ++i) {
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
            }
            long age = request.getTimeStamp() - ts;
            if (Log.isDebugEnabled()) {
                Log.debug((String)("age=" + age));
            }
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(n2, 0, 16);
                hash = md.digest();
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
            for (int i = 0; i < 16; ++i) {
                if (n[i + 8] == hash[i]) continue;
                return -1;
            }
            if (this._maxNonceAge > 0L && (age < 0L || age > this._maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
            return -1;
        }
    }

    private static class Digest
    extends Credential {
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        public boolean check(Object credentials) {
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(this.realm.getBytes(StringUtil.__ISO_8859_1));
                    md.update((byte)58);
                    md.update(password.getBytes(StringUtil.__ISO_8859_1));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StringUtil.__ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString((byte[])ha1, (int)16).getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.nc.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.cnonce.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(this.qop.getBytes(StringUtil.__ISO_8859_1));
                md.update((byte)58);
                md.update(TypeUtil.toString((byte[])ha2, (int)16).getBytes(StringUtil.__ISO_8859_1));
                byte[] digest = md.digest();
                return TypeUtil.toString((byte[])digest, (int)16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

