/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authentication;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthentication;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DelegateAuthenticator;

public class SessionCachingAuthenticator
extends DelegateAuthenticator {
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.server.Auth";

    public SessionCachingAuthenticator(Authenticator delegate) {
        super(delegate);
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        HttpSession session = ((HttpServletRequest)request).getSession(mandatory);
        if (session == null) {
            return DefaultAuthentication.SUCCESS_UNAUTH_RESULTS;
        }
        Authentication authentication = (Authentication)session.getAttribute(__J_AUTHENTICATED);
        if (authentication != null) {
            return authentication;
        }
        authentication = this._delegate.validateRequest(request, response, mandatory);
        if (authentication != null && authentication.getUserIdentity().getSubject() != null) {
            DefaultAuthentication next = new DefaultAuthentication(Authentication.Status.SUCCESS, authentication.getAuthMethod(), authentication.getUserIdentity());
            session.setAttribute(__J_AUTHENTICATED, (Object)next);
        }
        return authentication;
    }
}

