/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.common.events.annotated;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.client.common.util.ReflectUtils;

public class CallableMethod {
    private static final Logger LOG = Log.getLogger(CallableMethod.class);
    protected final Class<?> pojo;
    protected final Method method;
    protected Class<?>[] paramTypes;

    public CallableMethod(Class<?> pojo, Method method) {
        Objects.requireNonNull(pojo, "Pojo cannot be null");
        Objects.requireNonNull(method, "Method cannot be null");
        this.pojo = pojo;
        this.method = method;
        this.paramTypes = method.getParameterTypes();
    }

    public Object call(Object obj, Object ... args) {
        if (this.pojo == null || this.method == null) {
            LOG.warn("Cannot execute call: pojo={}, method={}", new Object[]{this.pojo, this.method});
            return null;
        }
        if (obj == null) {
            LOG.warn("Cannot call {} on null object", new Object[]{this.method});
            return null;
        }
        if (args.length < this.paramTypes.length) {
            throw new IllegalArgumentException("Call arguments length [" + args.length + "] must always be greater than or equal to captured args length [" + this.paramTypes.length + "]");
        }
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            StringBuilder err = new StringBuilder();
            err.append("Cannot call method ");
            err.append(ReflectUtils.toString(this.pojo, this.method));
            err.append(" with args: [");
            boolean delim = false;
            for (Object arg : args) {
                if (delim) {
                    err.append(", ");
                }
                if (arg == null) {
                    err.append("<null>");
                } else {
                    err.append(arg.getClass().getName());
                }
                delim = true;
            }
            err.append("]");
            throw new WebSocketException(err.toString(), (Throwable)e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    public Class<?> getPojo() {
        return this.pojo;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.method.toGenericString());
    }
}

