/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.common.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.client.common.WebSocketSession;
import org.eclipse.jetty.websocket.client.common.frames.BinaryFrame;

public class MessageOutputStream
extends OutputStream {
    private static final Logger LOG = Log.getLogger(MessageOutputStream.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount = 0L;
    private BinaryFrame frame;
    private ByteBuffer buffer;
    private WriteCallback callback;
    private boolean closed = false;

    public MessageOutputStream(OutgoingFrames outgoing, int bufferSize, ByteBufferPool bufferPool) {
        this.outgoing = outgoing;
        this.bufferPool = bufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = bufferPool.acquire(bufferSize, true);
        BufferUtil.flipToFill((ByteBuffer)this.buffer);
        this.frame = new BinaryFrame();
    }

    public MessageOutputStream(WebSocketSession session) {
        this(session.getOutgoingHandler(), session.getPolicy().getMaxBinaryMessageBufferSize(), session.getBufferPool());
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            IOException e = new IOException("Stream is closed");
            this.notifyFailure(e);
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.assertNotClosed();
        LOG.debug("close()", new Object[0]);
        this.flush(true);
        LOG.debug("Sent Frame Count: {}", this.frameCount);
        this.closed = true;
        try {
            if (this.callback != null) {
                this.callback.writeSuccess();
            }
            super.close();
            this.bufferPool.release(this.buffer);
            LOG.debug("closed", new Object[0]);
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        LOG.debug("flush()", new Object[0]);
        this.assertNotClosed();
        this.flush(false);
        try {
            super.flush();
            LOG.debug("flushed", new Object[0]);
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    private synchronized void flush(boolean fin) throws IOException {
        BufferUtil.flipToFlush((ByteBuffer)this.buffer, (int)0);
        LOG.debug("flush({}): {}", new Object[]{fin, BufferUtil.toDetailString((ByteBuffer)this.buffer)});
        this.frame.setPayload(this.buffer);
        this.frame.setFin(fin);
        try {
            this.outgoing.outgoingFrame((Frame)this.frame, (WriteCallback)this.blocker);
            this.blocker.block();
            ++this.frameCount;
            this.frame.setIsContinuation();
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    private void notifyFailure(IOException e) {
        if (this.callback != null) {
            this.callback.writeFailed((Throwable)e);
        }
    }

    public void setCallback(WriteCallback callback) {
        this.callback = callback;
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        try {
            this.write(b, 0, b.length);
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        LOG.debug("write(byte[{}], {}, {})", new Object[]{b.length, off, len});
        int left = len;
        int offset = off;
        while (left > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("buffer: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)this.buffer)});
            }
            int space = this.buffer.remaining();
            assert (space > 0);
            int size = Math.min(space, left);
            this.buffer.put(b, offset, size);
            assert (size > 0);
            if ((left -= size) > 0) {
                this.flush(false);
            }
            offset += size;
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.assertNotClosed();
        this.buffer.put((byte)b);
        if (this.buffer.remaining() <= 0) {
            this.flush(false);
        }
    }
}

