/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.common.message;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.client.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.client.common.WebSocketSession;
import org.eclipse.jetty.websocket.client.common.frames.TextFrame;
import org.eclipse.jetty.websocket.client.common.message.Utf8CharBuffer;

public class MessageWriter
extends Writer {
    private static final Logger LOG = Log.getLogger(MessageWriter.class);
    private final OutgoingFrames outgoing;
    private final ByteBufferPool bufferPool;
    private final BlockingWriteCallback blocker;
    private long frameCount = 0L;
    private TextFrame frame;
    private ByteBuffer buffer;
    private Utf8CharBuffer utf;
    private WriteCallback callback;
    private boolean closed = false;

    public MessageWriter(OutgoingFrames outgoing, int bufferSize, ByteBufferPool bufferPool) {
        this.outgoing = outgoing;
        this.bufferPool = bufferPool;
        this.blocker = new BlockingWriteCallback();
        this.buffer = bufferPool.acquire(bufferSize, true);
        BufferUtil.flipToFill((ByteBuffer)this.buffer);
        this.utf = Utf8CharBuffer.wrap(this.buffer);
        this.frame = new TextFrame();
    }

    public MessageWriter(WebSocketSession session) {
        this(session.getOutgoingHandler(), session.getPolicy().getMaxTextMessageBufferSize(), session.getBufferPool());
    }

    private void assertNotClosed() throws IOException {
        if (this.closed) {
            IOException e = new IOException("Stream is closed");
            this.notifyFailure(e);
            throw e;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.assertNotClosed();
        this.flush(true);
        this.closed = true;
        if (this.callback != null) {
            this.callback.writeSuccess();
        }
        this.bufferPool.release(this.buffer);
        LOG.debug("closed (frame count={})", this.frameCount);
    }

    @Override
    public void flush() throws IOException {
        this.assertNotClosed();
        this.flush(false);
    }

    private synchronized void flush(boolean fin) throws IOException {
        ByteBuffer data = this.utf.getByteBuffer();
        this.frame.setPayload(data);
        this.frame.setFin(fin);
        try {
            this.outgoing.outgoingFrame((Frame)this.frame, (WriteCallback)this.blocker);
            this.blocker.block();
            this.utf.clear();
            ++this.frameCount;
            this.frame.setIsContinuation();
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    private void notifyFailure(IOException e) {
        if (this.callback != null) {
            this.callback.writeFailed((Throwable)e);
        }
    }

    public void setCallback(WriteCallback callback) {
        this.callback = callback;
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        try {
            this.write(cbuf, 0, cbuf.length);
        }
        catch (IOException e) {
            this.notifyFailure(e);
            throw e;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.assertNotClosed();
        int left = len;
        int offset = off;
        while (left > 0) {
            int space = this.utf.remaining();
            int size = Math.min(space, left);
            assert (space > 0);
            assert (size > 0);
            this.utf.append(cbuf, offset, size);
            if ((left -= size) > 0) {
                this.flush(false);
            }
            offset += size;
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.assertNotClosed();
        this.utf.append(c);
        if (this.utf.remaining() <= 0) {
            this.flush(false);
        }
    }
}

