/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultTychoRepositoryIndex
implements TychoRepositoryIndex {
    protected static final String ENCODING = "UTF8";
    protected static final String EOL = "\n";
    private Set<GAV> gavs;

    DefaultTychoRepositoryIndex() {
        this(Collections.emptySet());
    }

    public DefaultTychoRepositoryIndex(Set<GAV> intitialContent) {
        this.gavs = new LinkedHashSet<GAV>(intitialContent);
    }

    @Override
    public Set<GAV> getProjectGAVs() {
        return Collections.unmodifiableSet(new LinkedHashSet<GAV>(this.gavs));
    }

    @Override
    public void addProject(GAV gav) {
        this.gavs.add(gav);
    }

    @Override
    public void remove(GAV gav) {
        this.gavs.remove(gav);
    }

    protected static void write(TychoRepositoryIndex index, OutputStream os) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), ENCODING);
        try {
            for (GAV gav : index.getProjectGAVs()) {
                out.write(gav.toExternalForm());
                out.write(EOL);
            }
            ((Writer)out).flush();
        }
        finally {
            ((Writer)out).close();
        }
    }

    protected static Set<GAV> read(InputStream is) throws IOException {
        LinkedHashSet<GAV> result = new LinkedHashSet<GAV>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, ENCODING));
        try {
            String str;
            while ((str = br.readLine()) != null) {
                result.add(GAV.parse(str));
            }
        }
        finally {
            br.close();
        }
        return result;
    }
}

