/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver.facade;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ResolutionResult {
    private final Map<List<String>, Entry> entries = new HashMap<List<String>, Entry>();
    private final Set<Object> nonReactorUnits = new LinkedHashSet<Object>();

    public void addArtifact(String type, String id, String version, File location, String classifier, Object installableUnit) {
        List<String> key = this.newKey(type, id, version);
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry(type, id, version, location, classifier);
            this.entries.put(key, entry);
        } else if (!P2ResolutionResult.eq(entry.getLocation(), location) || !P2ResolutionResult.eq(entry.getClassifier(), classifier)) {
            throw new IllegalArgumentException("Conflicting results for artifact at location " + location);
        }
        entry.addInstallableUnit(installableUnit);
    }

    private List<String> newKey(String type, String id, String version) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(type);
        key.add(id);
        key.add(version);
        return key;
    }

    public Collection<Entry> getArtifacts() {
        return this.entries.values();
    }

    public Set<?> getNonReactorUnits() {
        return this.nonReactorUnits;
    }

    public void addNonReactorUnit(Object installableUnit) {
        this.nonReactorUnits.add(installableUnit);
    }

    public void addNonReactorUnits(Set<?> installableUnits) {
        this.nonReactorUnits.addAll(installableUnits);
    }

    static <T> boolean eq(T a, T b) {
        return a != null ? a.equals(b) : b == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry {
        private final String type;
        private final String id;
        private final String version;
        private final File location;
        private Set<Object> installableUnits;
        private final String classifier;

        public Entry(String type, String id, String version, File location, String classifier) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.location = location;
            this.classifier = classifier;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public File getLocation() {
            return this.location;
        }

        public Set<Object> getInstallableUnits() {
            return this.installableUnits;
        }

        void addInstallableUnit(Object installableUnit) {
            if (this.installableUnits == null) {
                this.installableUnits = new LinkedHashSet<Object>();
            }
            this.installableUnits.add(installableUnit);
        }

        public String getClassifier() {
            return this.classifier;
        }
    }
}

