/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.proxy;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.tycho.p2.metadata.ProxyServiceFacade;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProxyServiceFacadeImpl
implements ProxyServiceFacade {
    private static final String MAVEN_SETTINGS_SOURCE = "MAVEN_SETTINGS";
    private static final Pattern NON_PROXY_DELIMITERS = Pattern.compile("\\s*[|,]\\s*");
    private IProxyService proxyService;

    public void configureProxy(String protocol, String host, int port, String user, String password, String nonProxyHosts) {
        try {
            ProxyData proxyData = new ProxyData(ProxyServiceFacadeImpl.getProxyType(protocol));
            proxyData.setHost(host);
            proxyData.setPort(port);
            proxyData.setUserid(user);
            proxyData.setPassword(password);
            proxyData.setSource(MAVEN_SETTINGS_SOURCE);
            this.proxyService.setProxyData(new IProxyData[]{proxyData});
            if (nonProxyHosts != null && nonProxyHosts.trim().length() > 0) {
                this.proxyService.setNonProxiedHosts(NON_PROXY_DELIMITERS.split(nonProxyHosts.trim()));
            }
            this.registerAuthenticator(user, password);
            this.proxyService.setProxiesEnabled(true);
            this.proxyService.setSystemProxiesEnabled(false);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void registerAuthenticator(final String user, final String password) {
        if (user == null || password == null) {
            return;
        }
        Authenticator authenticator = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
    }

    private static String getProxyType(String protocol) {
        String type;
        if ("http".equals(protocol = protocol.trim().toLowerCase(Locale.ENGLISH))) {
            type = "HTTP";
        } else if ("https".equals(protocol)) {
            type = "HTTPS";
        } else if ("socks4".equals(protocol) || "socks_5".equals(protocol)) {
            type = "SOCKS";
        } else {
            throw new IllegalArgumentException("unknown proxy protocol: " + protocol);
        }
        return type;
    }

    public void clearPersistentProxySettings() {
        IEclipsePreferences netPreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.core.net");
        try {
            ProxyServiceFacadeImpl.recursiveClear((Preferences)netPreferences);
            netPreferences.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private static void recursiveClear(Preferences preferences) throws BackingStoreException {
        String[] stringArray = preferences.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            ProxyServiceFacadeImpl.recursiveClear(preferences.node(child));
            ++n2;
        }
        preferences.clear();
    }

    public void setProxyServer(IProxyService proxyService) {
        this.proxyService = proxyService;
    }

    public void unsetProxyServer(IProxyService proxyService) {
        this.proxyService = null;
    }
}

