/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependenciesAction
extends AbstractPublisherAction {
    protected static final org.eclipse.equinox.p2.metadata.Version OSGi_versionMin = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)0, (int)0, (int)0);
    protected static final String ANY_QUALIFIER = "qualifier";
    protected static final String OSGI_OS = "osgi.os";
    protected static final String OSGI_WS = "osgi.ws";
    protected static final String OSGI_ARCH = "osgi.arch";
    protected static final String OSGI_NL = "osgi.nl";
    protected static final String FEATURE_GROUP_IU_SUFFIX = ".feature.group";

    protected void addRequiredCapability(Set<IRequirement> required, String id, org.eclipse.equinox.p2.metadata.Version version, String filter) {
        VersionRange range = this.getVersionRange(version);
        required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)filter), (boolean)false, (boolean)false));
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        iud.setId(this.getId());
        iud.setVersion(this.getVersion());
        LinkedHashSet<IProvidedCapability> provided = new LinkedHashSet<IProvidedCapability>();
        this.addProvidedCapabilities(provided);
        provided.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iud.getId(), (org.eclipse.equinox.p2.metadata.Version)iud.getVersion()));
        iud.addProvidedCapabilities(provided);
        iud.addRequirements(this.getRequiredCapabilities());
        this.addProperties(iud);
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud), "root");
        return Status.OK_STATUS;
    }

    protected void addProperties(MetadataFactory.InstallableUnitDescription iud) {
    }

    protected abstract Set<IRequirement> getRequiredCapabilities();

    protected void addProvidedCapabilities(Set<IProvidedCapability> provided) {
    }

    protected abstract org.eclipse.equinox.p2.metadata.Version getVersion();

    protected abstract String getId();

    protected VersionRange getVersionRange(String version) {
        if (version == null) {
            return VersionRange.emptyRange;
        }
        return this.getVersionRange(org.eclipse.equinox.p2.metadata.Version.create((String)version));
    }

    protected VersionRange getVersionRange(org.eclipse.equinox.p2.metadata.Version version) {
        if (version == null || OSGi_versionMin.equals(version)) {
            return VersionRange.emptyRange;
        }
        Version osgiVersion = PublisherHelper.toOSGiVersion((org.eclipse.equinox.p2.metadata.Version)version);
        String qualifier = osgiVersion.getQualifier();
        if (qualifier == null || "".equals(qualifier) || ANY_QUALIFIER.equals(qualifier)) {
            org.eclipse.equinox.p2.metadata.Version from = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro());
            org.eclipse.equinox.p2.metadata.Version to = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)(osgiVersion.getMicro() + 1));
            return new VersionRange(from, true, to, false);
        }
        return new VersionRange(version, true, version, true);
    }

    protected String getFilter(String os, String ws, String arch) {
        return this.getFilter(null, os, ws, arch, null);
    }

    protected String getFilter(String filter, String os, String ws, String arch, String nl) {
        ArrayList<String> conditions = new ArrayList<String>();
        if (filter != null) {
            conditions.add(filter);
        }
        if (os != null) {
            conditions.add("osgi.os=" + os);
        }
        if (ws != null) {
            conditions.add("osgi.ws=" + ws);
        }
        if (arch != null) {
            conditions.add("osgi.arch=" + arch);
        }
        if (nl != null) {
            conditions.add("osgi.nl=" + arch);
        }
        if (conditions.isEmpty()) {
            return null;
        }
        if (conditions.size() == 1) {
            return "(" + (String)conditions.get(0) + ")";
        }
        StringBuilder result = new StringBuilder("(&");
        for (String condition : conditions) {
            result.append(" (").append(condition).append(")");
        }
        result.append(" )");
        return result.toString();
    }

    protected org.eclipse.equinox.p2.metadata.Version createVersion(String version) {
        return org.eclipse.equinox.p2.metadata.Version.create((String)version);
    }
}

