/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2.impl.publisher.DummyMetadataRepository;
import org.eclipse.tycho.p2.impl.publisher.Utils;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadataGenerator {
    private IProgressMonitor monitor = new NullProgressMonitor();

    protected void generateMetadata(IArtifactFacade artifact, List<Map<String, String>> environments, Set<IInstallableUnit> units, Set<IArtifactDescriptor> artifacts, PublisherInfo publisherInfo) {
        if (publisherInfo.getMetadataRepository() == null) {
            publisherInfo.setMetadataRepository((IMetadataRepository)new DummyMetadataRepository());
        }
        for (IPublisherAdvice advice : this.getPublisherAdvice(artifact)) {
            publisherInfo.addAdvice(advice);
        }
        List<IPublisherAction> actions = this.getPublisherActions(artifact, environments);
        this.publish(units, artifacts, publisherInfo, actions);
    }

    protected abstract List<IPublisherAction> getPublisherActions(IArtifactFacade var1, List<Map<String, String>> var2);

    protected abstract List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade var1);

    protected ICapabilityAdvice getExtraEntriesAdvice(IArtifactFacade artifact) {
        final IRequirement[] extraRequirements = this.extractExtraEntriesAsIURequirement(artifact.getLocation());
        return new ICapabilityAdvice(){

            public boolean isApplicable(String configSpec, boolean includeDefault, String id, Version version) {
                return true;
            }

            public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return extraRequirements;
            }

            public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return null;
            }

            public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
                return null;
            }
        };
    }

    private IRequirement[] extractExtraEntriesAsIURequirement(File location) {
        Properties buildProperties = Utils.loadBuildProperties(location);
        if (buildProperties == null || buildProperties.size() == 0) {
            return null;
        }
        ArrayList<IRequirement> result = new ArrayList<IRequirement>();
        Set<Map.Entry<Object, Object>> pairs = buildProperties.entrySet();
        for (Map.Entry<Object, Object> pair : pairs) {
            String buildPropertyKey;
            if (!(pair.getValue() instanceof String) || !(buildPropertyKey = (String)pair.getKey()).startsWith("extra.")) continue;
            this.createRequirementFromExtraClasspathProperty(result, ((String)pair.getValue()).split(","));
        }
        String extra = buildProperties.getProperty("jars.extra.classpath");
        if (extra != null) {
            this.createRequirementFromExtraClasspathProperty(result, extra.split(","));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new IRequirement[result.size()]);
    }

    private void createRequirementFromExtraClasspathProperty(ArrayList<IRequirement> result, String[] urls) {
        int i = 0;
        while (i < urls.length) {
            this.createRequirementFromPlatformURL(result, urls[i].trim());
            ++i;
        }
    }

    private void createRequirementFromPlatformURL(ArrayList<IRequirement> result, String url) {
        Pattern platformURL = Pattern.compile("platform:/(plugin|fragment)/([^/]*)(/)*.*");
        Matcher m = platformURL.matcher(url);
        if (m.matches()) {
            result.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)m.group(2), (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)false));
        }
    }

    private void publish(Set<IInstallableUnit> units, Set<IArtifactDescriptor> artifacts, PublisherInfo publisherInfo, List<IPublisherAction> actions) {
        IArtifactRepository artifactRepository;
        PublisherResult result = new PublisherResult();
        Publisher publisher = new Publisher((IPublisherInfo)publisherInfo, (IPublisherResult)result);
        IStatus status = publisher.publish(actions.toArray(new IPublisherAction[actions.size()]), this.monitor);
        if (!status.isOK()) {
            throw new RuntimeException(StatusTool.collectProblems((IStatus)status), status.getException());
        }
        if (units != null) {
            units.addAll(result.getIUs(null, null));
        }
        if (artifacts != null && (artifactRepository = publisherInfo.getArtifactRepository()) instanceof TransientArtifactRepository) {
            artifacts.addAll(((TransientArtifactRepository)artifactRepository).getArtifactDescriptors());
        }
    }
}

