/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.tycho.p2.impl.publisher.AbstractDependenciesAction;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureDependenciesAction
extends AbstractDependenciesAction {
    public static final String INCLUDED_IUS = "org.eclipse.tycho.p2.includedIUs";
    private final Feature feature;

    public FeatureDependenciesAction(Feature feature) {
        this.feature = feature;
    }

    private String getInstallableUnitId(FeatureEntry entry) {
        if (entry.isPlugin()) {
            return entry.getId();
        }
        return String.valueOf(entry.getId()) + ".feature.group";
    }

    private VersionRange getVersionRange(FeatureEntry entry) {
        String versionSpec = entry.getVersion();
        if (versionSpec == null) {
            return VersionRange.emptyRange;
        }
        String match = entry.getMatch();
        if ("versionRange".equals(match)) {
            return new VersionRange(versionSpec);
        }
        org.eclipse.equinox.p2.metadata.Version version = org.eclipse.equinox.p2.metadata.Version.parseVersion((String)versionSpec);
        if (version.equals(org.eclipse.equinox.p2.metadata.Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (!entry.isRequires()) {
            return new VersionRange(version, true, version, true);
        }
        if (match == null) {
            return null;
        }
        if (match.equals("perfect")) {
            return new VersionRange(version, true, version, true);
        }
        Version osgiVersion = PublisherHelper.toOSGiVersion((org.eclipse.equinox.p2.metadata.Version)version);
        if (match.equals("equivalent")) {
            org.eclipse.equinox.p2.metadata.Version upper = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)osgiVersion.getMajor(), (int)(osgiVersion.getMinor() + 1), (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("compatible")) {
            org.eclipse.equinox.p2.metadata.Version upper = org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(osgiVersion.getMajor() + 1), (int)0, (int)0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("greaterOrEqual")) {
            return new VersionRange(version, true, new VersionRange(null).getMaximum(), true);
        }
        return null;
    }

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        FeatureEntry[] featureEntryArray = this.feature.getEntries();
        int n = featureEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            if (!entry.isPatch()) {
                VersionRange range = entry.isRequires() ? this.getVersionRange(entry) : this.getVersionRange(this.createVersion(entry.getVersion()));
                String id = this.getInstallableUnitId(entry);
                String filter = this.getFilter(entry.getFilter(), entry.getOS(), entry.getWS(), entry.getArch(), entry.getNL());
                boolean optional = entry.isOptional();
                required.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, (IMatchExpression)InstallableUnit.parseFilter((String)filter), (boolean)optional, (boolean)false));
            }
            ++n2;
        }
        return required;
    }

    @Override
    protected org.eclipse.equinox.p2.metadata.Version getVersion() {
        return org.eclipse.equinox.p2.metadata.Version.create((String)this.feature.getVersion());
    }

    @Override
    protected String getId() {
        return String.valueOf(this.feature.getId()) + ".feature.group";
    }

    @Override
    protected void addProvidedCapabilities(Set<IProvidedCapability> provided) {
        provided.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)this.feature.getId(), (org.eclipse.equinox.p2.metadata.Version)this.getVersion()));
    }

    @Override
    protected void addProperties(MetadataFactory.InstallableUnitDescription iud) {
        iud.setProperty("org.eclipse.equinox.p2.type.group", "true");
        StringBuilder includedIUs = new StringBuilder();
        FeatureEntry[] featureEntryArray = this.feature.getEntries();
        int n = featureEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureEntry entry = featureEntryArray[n2];
            String id = this.getInstallableUnitId(entry);
            if (includedIUs.length() > 0) {
                includedIUs.append(',');
            }
            includedIUs.append(id);
            ++n2;
        }
        iud.setProperty(INCLUDED_IUS, includedIUs.toString());
    }

    public static Set<String> getIncludedUIs(IInstallableUnit iu) {
        LinkedHashSet<String> includedIUs = new LinkedHashSet<String>();
        String prop = iu.getProperty(INCLUDED_IUS);
        if (prop != null) {
            StringTokenizer st = new StringTokenizer(prop, ",");
            while (st.hasMoreTokens()) {
                includedIUs.add(st.nextToken());
            }
        }
        return includedIUs;
    }
}

