/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.tycho.p2.impl.publisher.AbstractDependenciesAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductDependenciesAction
extends AbstractDependenciesAction {
    private final IProductDescriptor product;
    private final List<Map<String, String>> environments;

    public ProductDependenciesAction(IProductDescriptor product, List<Map<String, String>> environments) {
        this.product = product;
        this.environments = environments;
    }

    @Override
    protected Version getVersion() {
        return Version.create((String)this.product.getVersion());
    }

    @Override
    protected String getId() {
        return this.product.getId();
    }

    @Override
    protected Set<IRequirement> getRequiredCapabilities() {
        LinkedHashSet<IRequirement> required = new LinkedHashSet<IRequirement>();
        if (this.product.useFeatures()) {
            for (IVersionedId iVersionedId : this.product.getFeatures()) {
                String id = String.valueOf(iVersionedId.getId()) + ".feature.group";
                Version version = iVersionedId.getVersion();
                this.addRequiredCapability(required, id, version, null);
            }
        } else {
            for (FeatureEntry featureEntry : ((ProductFile)this.product).getProductEntries()) {
                this.addRequiredCapability(required, featureEntry.getId(), Version.parseVersion((String)featureEntry.getVersion()), this.getFilter(featureEntry));
            }
        }
        this.addRequiredCapability(required, "org.eclipse.equinox.executable.feature.group", null, null);
        this.addRequiredCapability(required, "org.eclipse.equinox.launcher", null, null);
        if (this.environments != null) {
            for (Map map : this.environments) {
                this.addNativeRequirements(required, (String)map.get("osgi.os"), (String)map.get("osgi.ws"), (String)map.get("osgi.arch"));
            }
        }
        return required;
    }

    private String getFilter(FeatureEntry entry) {
        if (entry.getOS() == null && entry.getWS() == null && entry.getArch() == null) {
            return null;
        }
        return this.getFilter(entry.getOS(), entry.getWS(), entry.getArch());
    }

    private void addNativeRequirements(Set<IRequirement> required, String os, String ws, String arch) {
        String filter = this.getFilter(os, ws, arch);
        if ("macosx".equals(os) && "x86".equals(arch)) {
            this.addRequiredCapability(required, "org.eclipse.equinox.launcher." + ws + "." + os, null, filter);
            return;
        }
        this.addRequiredCapability(required, "org.eclipse.equinox.launcher." + ws + "." + os + "." + arch, null, filter);
    }
}

