/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.publisher;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.tycho.p2.impl.publisher.AbstractMetadataGenerator;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.metadata.DependencyMetadataGenerator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcesBundleDependencyMetadataGenerator
extends AbstractMetadataGenerator
implements DependencyMetadataGenerator {
    private static final String SUFFIX_QUALIFIER = ".qualifier";
    private static final String SUFFIX_SNAPSHOT = "-SNAPSHOT";

    public Set<Object> generateMetadata(IArtifactFacade artifact, List<Map<String, String>> environments) {
        LinkedHashSet<IInstallableUnit> units = new LinkedHashSet<IInstallableUnit>();
        LinkedHashSet<IArtifactDescriptor> artifactDescriptors = new LinkedHashSet<IArtifactDescriptor>();
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(3);
        publisherInfo.setArtifactRepository((IArtifactRepository)new TransientArtifactRepository());
        super.generateMetadata(artifact, environments, units, artifactDescriptors, publisherInfo);
        return new LinkedHashSet<IInstallableUnit>(units);
    }

    @Override
    protected List<IPublisherAction> getPublisherActions(IArtifactFacade artifact, List<Map<String, String>> environments) {
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        String id = artifact.getArtifactId();
        String version = SourcesBundleDependencyMetadataGenerator.toCanonicalVersion(artifact.getVersion());
        try {
            Hashtable<String, String> manifest = new Hashtable<String, String>();
            ((Dictionary)manifest).put("Manifest-Version", "1.0");
            ((Dictionary)manifest).put("Bundle-ManifestVersion", "2");
            String sourceBundleSymbolicName = String.valueOf(id) + ".source";
            ((Dictionary)manifest).put("Bundle-SymbolicName", sourceBundleSymbolicName);
            ((Dictionary)manifest).put("Bundle-Version", version);
            ((Dictionary)manifest).put("Eclipse-SourceBundle", String.valueOf(id) + ";version=" + version + ";roots:=\".\"");
            StateObjectFactory factory = StateObjectFactory.defaultFactory;
            BundleDescription bundleDescription = factory.createBundleDescription(factory.createState(false), manifest, artifact.getLocation().getAbsolutePath(), this.createId(sourceBundleSymbolicName, version));
            bundleDescription.setUserObject(manifest);
            actions.add((IPublisherAction)new BundlesAction(new BundleDescription[]{bundleDescription}));
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
        return actions;
    }

    @Override
    protected List<IPublisherAdvice> getPublisherAdvice(IArtifactFacade artifact) {
        ArrayList<IPublisherAdvice> advice = new ArrayList<IPublisherAdvice>();
        advice.add((IPublisherAdvice)new MavenPropertiesAdvice(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "sources"));
        return advice;
    }

    private static String toCanonicalVersion(String version) {
        if (version == null) {
            return null;
        }
        if (version.endsWith(SUFFIX_SNAPSHOT)) {
            return String.valueOf(version.substring(0, version.length() - SUFFIX_SNAPSHOT.length())) + SUFFIX_QUALIFIER;
        }
        return version;
    }

    public long createId(String sourceBundleSymbolicName, String version) {
        return (long)sourceBundleSymbolicName.hashCode() | (long)version.hashCode() << 32;
    }
}

