/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCache;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2RepositoryCacheImpl
implements P2RepositoryCache {
    private HashMap<URI, SoftReference<IArtifactRepository>> artifactRepositories = new HashMap();
    private HashMap<URI, SoftReference<IMetadataRepository>> metadataRepositories = new HashMap();
    private HashMap<String, TychoRepositoryIndex> indexes = new HashMap();

    @Override
    public IArtifactRepository getArtifactRepository(URI uri) {
        return this.dereference(this.artifactRepositories.get(uri));
    }

    private <T> T dereference(SoftReference<T> reference) {
        return reference != null ? (T)reference.get() : null;
    }

    @Override
    public IMetadataRepository getMetadataRepository(URI uri) {
        return this.dereference(this.metadataRepositories.get(uri));
    }

    @Override
    public void putRepository(URI uri, IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) {
        if (metadataRepository != null) {
            this.metadataRepositories.put(uri, new SoftReference<IMetadataRepository>(metadataRepository));
        }
        if (artifactRepository != null) {
            this.artifactRepositories.put(uri, new SoftReference<IArtifactRepository>(artifactRepository));
        }
    }

    public TychoRepositoryIndex getRepositoryIndex(String repositoryKey) {
        return this.indexes.get(repositoryKey);
    }

    public void putRepositoryIndex(String repositoryKey, TychoRepositoryIndex index) {
        this.indexes.put(repositoryKey, index);
    }
}

