/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.Activator;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCache;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCacheImpl;
import org.eclipse.tycho.p2.impl.resolver.P2ResolverImpl;
import org.eclipse.tycho.p2.impl.resolver.ResolutionContextImpl;
import org.eclipse.tycho.p2.impl.resolver.TychoP2RepositoryCacheManager;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;

public class P2ResolverFactoryImpl
implements P2ResolverFactory {
    private static final Map<AgentKey, IProvisioningAgent> agents = new HashMap<AgentKey, IProvisioningAgent>();

    public ResolutionContextImpl createResolutionContext(File localMavenRepositoryRoot, boolean offline, boolean disableP2Mirrors, MavenLogger logger) {
        IProvisioningAgent agent = P2ResolverFactoryImpl.getProvisioningAgent(localMavenRepositoryRoot, offline);
        return new ResolutionContextImpl(agent, localMavenRepositoryRoot, offline, disableP2Mirrors, logger);
    }

    public P2ResolverImpl createResolver(MavenLogger logger) {
        return new P2ResolverImpl(logger);
    }

    public static synchronized IProvisioningAgent getProvisioningAgent(File localMavenRepositoryRoot, boolean offline) {
        AgentKey agentKey = new AgentKey(localMavenRepositoryRoot, offline);
        IProvisioningAgent agent = agents.get(agentKey);
        if (agent == null) {
            try {
                agent = Activator.newProvisioningAgent();
                Transport transport = (Transport)agent.getService(Transport.SERVICE_NAME);
                TychoP2RepositoryCacheManager cacheMgr = new TychoP2RepositoryCacheManager(transport);
                cacheMgr.setOffline(offline);
                cacheMgr.setLocalRepositoryLocation(localMavenRepositoryRoot);
                agent.registerService(CacheManager.SERVICE_NAME, (Object)cacheMgr);
                P2RepositoryCacheImpl tychoCache = new P2RepositoryCacheImpl();
                agent.registerService(P2RepositoryCache.SERVICE_NAME, (Object)tychoCache);
                agents.put(agentKey, agent);
            }
            catch (ProvisionException e) {
                throw new RuntimeException(e);
            }
        }
        return agent;
    }

    private static class AgentKey {
        public final File localMavenRepositoryRoot;
        public final boolean offline;

        public AgentKey(File localMavenRepositoryRoot, boolean offline) {
            this.localMavenRepositoryRoot = localMavenRepositoryRoot;
            this.offline = offline;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 31 + this.localMavenRepositoryRoot.hashCode();
            hash = hash * 31 + (this.offline ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AgentKey)) {
                return false;
            }
            AgentKey other = (AgentKey)obj;
            return this.localMavenRepositoryRoot.equals(other.localMavenRepositoryRoot) && this.offline == other.offline;
        }
    }
}

