/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.DependencyCollector;
import org.eclipse.tycho.p2.impl.resolver.LoggingProgressMonitor;
import org.eclipse.tycho.p2.impl.resolver.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.ResolutionContextImpl;
import org.eclipse.tycho.p2.impl.resolver.ResolutionStrategy;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IReactorArtifactFacade;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.resolver.facade.ResolutionContext;
import org.eclipse.tycho.repository.registry.facade.RepositoryBlackboardKey;
import org.eclipse.tycho.repository.registry.impl.ArtifactRepositoryBlackboard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2ResolverImpl
implements P2Resolver {
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private List<Map<String, String>> environments;
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private ResolutionContextImpl context;

    public P2ResolverImpl(MavenLogger logger) {
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
    }

    public List<P2ResolutionResult> resolveProject(ResolutionContext context, File projectLocation) {
        this.context = (ResolutionContextImpl)context;
        ArrayList<P2ResolutionResult> results = new ArrayList<P2ResolutionResult>();
        for (Map<String, String> properties : this.environments) {
            results.add(this.resolveProject(projectLocation, new ProjectorResolutionStrategy(properties, this.logger)));
        }
        return results;
    }

    public P2ResolutionResult collectProjectDependencies(ResolutionContext context, File projectLocation) {
        this.context = (ResolutionContextImpl)context;
        return this.resolveProject(projectLocation, new DependencyCollector(this.logger));
    }

    public P2ResolutionResult resolveMetadata(ResolutionContext context, Map<String, String> properties) {
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(properties, this.logger);
        strategy.setAvailableInstallableUnits(((ResolutionContextImpl)context).gatherAvailableInstallableUnits(this.monitor));
        strategy.setRootInstallableUnits(new HashSet<IInstallableUnit>());
        strategy.setAdditionalRequirements(this.additionalRequirements);
        P2ResolutionResult result = new P2ResolutionResult();
        for (IInstallableUnit iu : strategy.resolve(this.monitor)) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), null, null, (Object)iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveProject(File projectLocation, ResolutionStrategy strategy) {
        this.context.assertNoDuplicateReactorUIs();
        strategy.setAvailableInstallableUnits(this.context.gatherAvailableInstallableUnits(this.monitor));
        LinkedHashSet<IInstallableUnit> projectIUs = this.context.getReactorProjectIUs(projectLocation);
        strategy.setRootInstallableUnits(projectIUs);
        strategy.setAdditionalRequirements(this.additionalRequirements);
        Collection<IInstallableUnit> newState = strategy.resolve(this.monitor);
        this.context.warnAboutLocalIus(newState);
        this.context.downloadArtifacts(newState);
        IArtifactRepository resolutionContextArtifactRepo = this.context.getSupplementaryArtifactRepository();
        RepositoryBlackboardKey blackboardKey = RepositoryBlackboardKey.forResolutionContextArtifacts((File)projectLocation);
        ArtifactRepositoryBlackboard.putRepository((RepositoryBlackboardKey)blackboardKey, (IArtifactRepository)resolutionContextArtifactRepo);
        this.logger.debug("Registered artifact repository " + blackboardKey);
        return this.toResolutionResult(newState);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> newState) {
        P2ResolutionResult result = new P2ResolutionResult();
        for (IInstallableUnit iu : newState) {
            IArtifactFacade mavenArtifact = this.context.getMavenArtifact(iu);
            if (mavenArtifact != null) {
                this.addMavenArtifact(result, mavenArtifact, iu);
                continue;
            }
            for (IArtifactKey key : iu.getArtifacts()) {
                this.addArtifactFile(result, iu, key);
            }
        }
        this.collectNonReactorIUs(result, newState);
        return result;
    }

    private void collectNonReactorIUs(P2ResolutionResult result, Collection<IInstallableUnit> newState) {
        for (IInstallableUnit iu : newState) {
            if (this.isReactorArtifact(iu)) continue;
            result.addNonReactorUnit((Object)iu);
        }
    }

    private boolean isReactorArtifact(IInstallableUnit iu) {
        return this.context.getMavenArtifact(iu) instanceof IReactorArtifactFacade;
    }

    private void addArtifactFile(P2ResolutionResult platform, IInstallableUnit iu, IArtifactKey key) {
        String featureId;
        String mavenClassidier;
        File file = this.context.getLocalArtifactFile(key);
        if (file == null) {
            return;
        }
        IArtifactFacade reactorArtifact = this.context.getMavenArtifact(iu);
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String string = mavenClassidier = reactorArtifact != null ? reactorArtifact.getClassidier() : null;
        if (CAPABILITY_NS_OSGI_BUNDLE.equals(key.getClassifier())) {
            platform.addArtifact("eclipse-plugin", id, version, file, mavenClassidier, (Object)iu);
        } else if ("org.eclipse.update.feature".equals(key.getClassifier()) && (featureId = this.getFeatureId(iu)) != null) {
            platform.addArtifact("eclipse-feature", featureId, version, file, mavenClassidier, (Object)iu);
        }
    }

    private void addMavenArtifact(P2ResolutionResult platform, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String type = mavenArtifact.getPackagingType();
        String id = iu.getId();
        String version = iu.getVersion().toString();
        File location = mavenArtifact.getLocation();
        String mavenClassidier = mavenArtifact.getClassidier();
        if ("eclipse-feature".equals(type)) {
            id = this.getFeatureId(iu);
            if (id == null) {
                throw new IllegalStateException("Feature id is null for maven artifact at " + mavenArtifact.getLocation() + " with classifier " + mavenArtifact.getClassidier());
            }
        } else if ("jar".equals(type)) {
            type = "eclipse-plugin";
        }
        platform.addArtifact(type, id, version, location, mavenClassidier, (Object)iu);
    }

    private String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    public void setEnvironments(List<Map<String, String>> environments) {
        this.environments = environments;
    }

    public void addDependency(String type, String id, String versionRange) {
        if ("p2-installable-unit".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-plugin".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)CAPABILITY_NS_OSGI_BUNDLE, (String)id, (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        } else if ("eclipse-feature".equals(type)) {
            this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)(String.valueOf(id) + ".feature.group"), (VersionRange)new VersionRange(versionRange), null, (boolean)false, (boolean)true));
        }
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }
}

