/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.ResolutionStrategy;
import org.eclipse.tycho.p2.impl.resolver.ResolverDebugUtils;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectorResolutionStrategy
extends ResolutionStrategy {
    private static final IInstallableUnit[] IU_ARRAY = new IInstallableUnit[0];
    private final Map<String, String> properties;
    private final MavenLogger logger;

    public ProjectorResolutionStrategy(Map<String, String> properties, MavenLogger logger) {
        this.properties = properties;
        this.logger = logger;
    }

    @Override
    public Collection<IInstallableUnit> resolve(IProgressMonitor monitor) {
        Slicer slicer;
        IQueryable slice;
        Map newSelectionContext = SimplePlanner.createSelectionContext(this.properties);
        Set<IInstallableUnit> extraIUs = this.createAdditionalRequirementsIU();
        LinkedHashSet<IInstallableUnit> rootWithExtraIUs = new LinkedHashSet<IInstallableUnit>();
        rootWithExtraIUs.addAll(this.rootIUs);
        rootWithExtraIUs.addAll(extraIUs);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Available IUs:\n" + ResolverDebugUtils.toDebugString((IQueryable<IInstallableUnit>)this.availableIUs, false, monitor));
            this.logger.debug("Root IUs:\n" + ResolverDebugUtils.toDebugString(this.rootIUs, true));
            this.logger.debug("Extra IUs:\n" + ResolverDebugUtils.toDebugString(extraIUs, true));
        }
        if ((slice = (slicer = new Slicer(this.availableIUs, newSelectionContext, false)).slice(rootWithExtraIUs.toArray(IU_ARRAY), monitor)) == null) {
            throw new RuntimeException(StatusTool.collectProblems((IStatus)slicer.getStatus()), (Throwable)new CoreException((IStatus)slicer.getStatus()));
        }
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Slice:\n" + ResolverDebugUtils.toDebugString((IQueryable<IInstallableUnit>)slice, false, monitor));
        }
        Projector projector = new Projector(slice, newSelectionContext, new HashSet(), false);
        projector.encode(this.createMetaIU(this.rootIUs), extraIUs.toArray(IU_ARRAY), (IQueryable)new QueryableArray(IU_ARRAY), (Collection)this.rootIUs, monitor);
        IStatus s = projector.invokeSolver(monitor);
        if (s.getSeverity() == 4) {
            Set explanation = projector.getExplanation(monitor);
            this.logger.info(newSelectionContext.toString());
            this.logger.error("Cannot resolve project dependencies:");
            for (Explanation explanationLine : explanation) {
                this.logger.error("  " + explanationLine.toString());
            }
            this.logger.error("");
            throw new RuntimeException(StatusTool.collectProblems((IStatus)s), s.getException());
        }
        Collection newState = projector.extractSolution();
        this.fixSWT(newState, newSelectionContext, monitor);
        if (this.logger.isExtendedDebugEnabled()) {
            this.logger.debug("Resolved IUs:\n" + ResolverDebugUtils.toDebugString(newState, false));
        }
        return newState;
    }

    private void fixSWT(Collection<IInstallableUnit> ius, Map<String, String> newSelectionContext, IProgressMonitor monitor) {
        boolean swt = false;
        for (IInstallableUnit iu : ius) {
            if (!"org.eclipse.swt".equals(iu.getId())) continue;
            swt = true;
            break;
        }
        if (!swt) {
            return;
        }
        IInstallableUnit swtFragment = null;
        block1: for (IInstallableUnit iu : this.availableIUs.query(QueryUtil.ALL_UNITS, monitor)) {
            if (!iu.getId().startsWith("org.eclipse.swt") || !this.isApplicable(newSelectionContext, (IMatchExpression<IInstallableUnit>)iu.getFilter())) continue;
            for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
                if (!"osgi.fragment".equals(provided.getNamespace()) || !"org.eclipse.swt".equals(provided.getName())) continue;
                if (swtFragment != null && swtFragment.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue block1;
                swtFragment = iu;
                continue block1;
            }
        }
        if (swtFragment == null) {
            throw new RuntimeException("Could not determine SWT implementation fragment bundle");
        }
        ius.add(swtFragment);
    }

    protected boolean isApplicable(Map<String, String> selectionContext, IMatchExpression<IInstallableUnit> filter) {
        if (filter == null) {
            return true;
        }
        return filter.isMatch((Object)InstallableUnit.contextIU(selectionContext));
    }

    private IInstallableUnit createMetaIU(Set<IInstallableUnit> rootIUs) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId(time);
        iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        for (IInstallableUnit iu : rootIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (int)1, (int)(iu.isSingleton() ? 1 : Integer.MAX_VALUE), (boolean)true));
        }
        requirements.addAll(this.additionalRequirements);
        iud.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private Set<IInstallableUnit> createAdditionalRequirementsIU() {
        LinkedHashSet<IInstallableUnit> result = new LinkedHashSet<IInstallableUnit>();
        if (!this.additionalRequirements.isEmpty()) {
            MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
            String time = Long.toString(System.currentTimeMillis());
            iud.setId("extra-" + time);
            iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
            iud.setRequirements((IRequirement[])this.additionalRequirements.toArray(new IRequiredCapability[this.additionalRequirements.size()]));
            result.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud));
        }
        return result;
    }
}

