/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.publisher.MavenPropertiesAdvice;
import org.eclipse.tycho.p2.impl.publisher.repo.TransientArtifactRepository;
import org.eclipse.tycho.p2.maven.repository.AbstractMavenArtifactRepository;
import org.eclipse.tycho.p2.maven.repository.Activator;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.util.StatusTool;

public class ResolutionContextBundlePublisher {
    private final MavenLogger logger;
    private final PublishedBundlesArtifactRepository publishedArtifacts;

    public ResolutionContextBundlePublisher(File localMavenRepositoryRoot, MavenLogger logger) {
        this.publishedArtifacts = new PublishedBundlesArtifactRepository(localMavenRepositoryRoot);
        this.logger = logger;
    }

    ResolutionContextBundlePublisher(RepositoryReader localMavenRepoProvider, MavenLogger logger) {
        this.publishedArtifacts = new PublishedBundlesArtifactRepository(localMavenRepoProvider);
        this.logger = logger;
    }

    IInstallableUnit attemptToPublishBundle(IArtifactFacade mavenArtifact) {
        IInstallableUnit publishedIU;
        if (!this.isAvailableAsLocalFile(mavenArtifact)) {
            throw new IllegalArgumentException("Not an artifact file: " + mavenArtifact.getLocation());
        }
        if (this.isCertainlyNoBundle(mavenArtifact)) {
            return null;
        }
        PublisherRun publisherRun = new PublisherRun(mavenArtifact);
        IStatus status = publisherRun.execute();
        if (!status.isOK()) {
            this.logger.warn(StatusTool.collectProblems((IStatus)status), status.getException());
        }
        if ((publishedIU = publisherRun.getPublishedUnitIfExists()) != null) {
            IArtifactDescriptor publishedArtifact = publisherRun.getPublishedArtifactDescriptor();
            this.publishedArtifacts.addDescriptor(publishedArtifact, mavenArtifact);
        }
        return publishedIU;
    }

    private boolean isAvailableAsLocalFile(IArtifactFacade artifact) {
        File localLocation = artifact.getLocation();
        return localLocation != null && localLocation.isFile();
    }

    private boolean isCertainlyNoBundle(IArtifactFacade artifact) {
        return !artifact.getLocation().getName().endsWith(".jar");
    }

    IArtifactRepository getArtifactRepoOfPublishedBundles() {
        return this.publishedArtifacts;
    }

    private static class PublishedBundlesArtifactRepository
    extends AbstractMavenArtifactRepository
    implements IFileArtifactRepository {
        PublishedBundlesArtifactRepository(File localMavenRepositoryRoot) {
            this((RepositoryReader)new LocalRepositoryReader(localMavenRepositoryRoot));
        }

        PublishedBundlesArtifactRepository(RepositoryReader artifactProvider) {
            super(Activator.getProvisioningAgent(), null, artifactProvider);
            super.setLocation(URI.create("memory:" + ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(System.identityHashCode((Object)this))));
        }

        public boolean isModifiable() {
            return true;
        }

        public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
            throw new AssertionFailedException("Unexpected method call");
        }

        void addDescriptor(IArtifactDescriptor descriptor, IArtifactFacade mavenArtifact) {
            this.addDescriptor((IArtifactDescriptor)PublishedBundlesArtifactRepository.createDescriptorWithGAV(descriptor, mavenArtifact));
        }

        private static ArtifactDescriptor createDescriptorWithGAV(IArtifactDescriptor descriptor, IArtifactFacade mavenArtifact) {
            ArtifactDescriptor internalDescriptor = new ArtifactDescriptor(descriptor);
            internalDescriptor.setProperty("maven-groupId", mavenArtifact.getGroupId());
            internalDescriptor.setProperty("maven-artifactId", mavenArtifact.getArtifactId());
            internalDescriptor.setProperty("maven-version", mavenArtifact.getVersion());
            internalDescriptor.setProperty("maven-classifier", null);
            internalDescriptor.setProperty("maven-extension", null);
            return internalDescriptor;
        }
    }

    private static class PublisherRun {
        private final IArtifactFacade mavenArtifact;
        private PublisherInfo publisherInfo;
        private TransientArtifactRepository collectedDescriptors;
        private PublisherResult publisherResult;

        PublisherRun(IArtifactFacade artifact) {
            this.mavenArtifact = artifact;
        }

        IStatus execute() {
            this.publisherInfo = new PublisherInfo();
            this.enableArtifactDescriptorCollection();
            this.enableUnitAnnotationWithGAV();
            BundlesAction bundlesAction = new BundlesAction(new File[]{this.mavenArtifact.getLocation()});
            IStatus status = this.executePublisherAction(bundlesAction);
            return status;
        }

        private void enableArtifactDescriptorCollection() {
            this.publisherInfo.setArtifactOptions(1);
            this.collectedDescriptors = new TransientArtifactRepository();
            this.publisherInfo.setArtifactRepository((IArtifactRepository)this.collectedDescriptors);
        }

        private void enableUnitAnnotationWithGAV() {
            MavenPropertiesAdvice advice = new MavenPropertiesAdvice(this.mavenArtifact.getGroupId(), this.mavenArtifact.getArtifactId(), this.mavenArtifact.getVersion(), this.mavenArtifact.getClassidier());
            this.publisherInfo.addAdvice((IPublisherAdvice)advice);
        }

        private IStatus executePublisherAction(BundlesAction action) {
            IPublisherAction[] actions = new IPublisherAction[]{action};
            this.publisherResult = new PublisherResult();
            return new Publisher((IPublisherInfo)this.publisherInfo, (IPublisherResult)this.publisherResult).publish(actions, null);
        }

        IInstallableUnit getPublishedUnitIfExists() {
            Collection units = this.publisherResult.getIUs(null, null);
            if (units.isEmpty()) {
                return null;
            }
            if (units.size() == 1) {
                return (IInstallableUnit)units.iterator().next();
            }
            throw new AssertionFailedException("BundlesAction produced more than one IU for " + this.mavenArtifact.getLocation());
        }

        IArtifactDescriptor getPublishedArtifactDescriptor() {
            Set<IArtifactDescriptor> descriptors = this.collectedDescriptors.getArtifactDescriptors();
            if (descriptors.isEmpty()) {
                throw new AssertionFailedException("BundlesAction did not create an artifact entry for " + this.mavenArtifact.getLocation());
            }
            if (descriptors.size() == 1) {
                return descriptors.iterator().next();
            }
            throw new AssertionFailedException("BundlesAction created more than one artifact entry for " + this.mavenArtifact.getLocation());
        }
    }
}

