/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.impl.resolver.ClassifiedLocation;
import org.eclipse.tycho.p2.impl.resolver.DuplicateReactorIUsException;
import org.eclipse.tycho.p2.impl.resolver.LoggingProgressMonitor;
import org.eclipse.tycho.p2.impl.resolver.P2RepositoryCache;
import org.eclipse.tycho.p2.impl.resolver.ResolutionContextBundlePublisher;
import org.eclipse.tycho.p2.maven.repository.LocalArtifactRepository;
import org.eclipse.tycho.p2.maven.repository.LocalMetadataRepository;
import org.eclipse.tycho.p2.maven.repository.MavenMirrorRequest;
import org.eclipse.tycho.p2.maven.repository.xmlio.MetadataIO;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.metadata.IReactorArtifactFacade;
import org.eclipse.tycho.p2.repository.FileBasedTychoRepositoryIndex;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.LocalRepositoryReader;
import org.eclipse.tycho.p2.repository.RepositoryReader;
import org.eclipse.tycho.p2.repository.TychoRepositoryIndex;
import org.eclipse.tycho.p2.resolver.facade.ResolutionContext;
import org.eclipse.tycho.p2.target.TargetDefinitionResolver;
import org.eclipse.tycho.p2.target.TargetPlatformContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionContextImpl
implements ResolutionContext {
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private final boolean offline;
    private final IProvisioningAgent agent;
    private final boolean disableP2Mirrors;
    private final LocalArtifactRepository localRepository;
    private final LocalMetadataRepository localMetadataRepository;
    private Map<ClassifiedLocation, Set<IInstallableUnit>> reactorProjectIUs = new HashMap<ClassifiedLocation, Set<IInstallableUnit>>();
    private Map<IInstallableUnit, IArtifactFacade> mavenInstallableUnits = new HashMap<IInstallableUnit, IArtifactFacade>();
    private Set<String> reactorInstallableUnitIds = new HashSet<String>();
    private final ResolutionContextBundlePublisher bundlesPublisher;
    private final List<IMetadataRepository> metadataRepositories = new ArrayList<IMetadataRepository>();
    private final List<IArtifactRepository> artifactRepositories = new ArrayList<IArtifactRepository>();
    private List<TargetPlatformContent> content = new ArrayList<TargetPlatformContent>();
    private static final IArtifactRequest[] ARTIFACT_REQUEST_ARRAY = new IArtifactRequest[0];
    private final IMetadataRepositoryManager metadataRepositoryManager;
    private final IArtifactRepositoryManager artifactRepositoryManager;
    private final P2RepositoryCache repositoryCache;

    ResolutionContextImpl(IProvisioningAgent agent, File localMavenRepositoryRoot, boolean offline, boolean disableP2Mirrors, MavenLogger logger) {
        this.agent = agent;
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.metadataRepositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (this.metadataRepositoryManager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        this.artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (this.artifactRepositoryManager == null) {
            throw new IllegalStateException("No artifact repository manager found");
        }
        this.repositoryCache = (P2RepositoryCache)agent.getService(P2RepositoryCache.SERVICE_NAME);
        if (this.repositoryCache == null) {
            throw new IllegalStateException("No Tycho p2 reposiutory cache found");
        }
        this.offline = offline;
        this.disableP2Mirrors = disableP2Mirrors;
        this.bundlesPublisher = new ResolutionContextBundlePublisher(localMavenRepositoryRoot, logger);
        URI uri = localMavenRepositoryRoot.toURI();
        LocalArtifactRepository localRepository = (LocalArtifactRepository)this.repositoryCache.getArtifactRepository(uri);
        LocalMetadataRepository localMetadataRepository = (LocalMetadataRepository)this.repositoryCache.getMetadataRepository(uri);
        if (localRepository == null || localMetadataRepository == null) {
            LocalRepositoryReader contentLocator = new LocalRepositoryReader(localMavenRepositoryRoot);
            TychoRepositoryIndex artifactsIndex = FileBasedTychoRepositoryIndex.createRepositoryIndex((File)localMavenRepositoryRoot, (String)".meta/p2-artifacts.properties");
            TychoRepositoryIndex metadataIndex = FileBasedTychoRepositoryIndex.createRepositoryIndex((File)localMavenRepositoryRoot, (String)".meta/p2-local-metadata.properties");
            localRepository = new LocalArtifactRepository(localMavenRepositoryRoot, artifactsIndex, (RepositoryReader)contentLocator);
            localMetadataRepository = new LocalMetadataRepository(uri, metadataIndex, (RepositoryReader)contentLocator);
            this.repositoryCache.putRepository(uri, (IMetadataRepository)localMetadataRepository, (IArtifactRepository)localRepository);
        }
        this.metadataRepositories.add((IMetadataRepository)localMetadataRepository);
        this.localMetadataRepository = localMetadataRepository;
        this.localRepository = localRepository;
    }

    public void addReactorArtifact(IReactorArtifactFacade artifact) {
        Set<IInstallableUnit> units = ResolutionContextImpl.toSet(artifact.getDependencyMetadata(), IInstallableUnit.class);
        ClassifiedLocation key = new ClassifiedLocation((IArtifactFacade)artifact);
        this.reactorProjectIUs.put(key, units);
        this.addMavenArtifact(key, (IArtifactFacade)artifact, units);
        for (IInstallableUnit unit : units) {
            this.reactorInstallableUnitIds.add(unit.getId());
        }
    }

    private static <T> Set<T> toSet(Collection<Object> collection, Class<T> targetType) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (Object o : collection) {
            set.add(targetType.cast(o));
        }
        return set;
    }

    public void addArtifactWithExistingMetadata(IArtifactFacade artifact, IArtifactFacade p2MetadataFile) {
        try {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, this.readUnits(p2MetadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read p2 metadata", e);
        }
    }

    private Set<IInstallableUnit> readUnits(IArtifactFacade p2MetadataFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(p2MetadataFile.getLocation());
        try {
            MetadataIO io = new MetadataIO();
            Set set = io.readXML((InputStream)inputStream);
            return set;
        }
        finally {
            inputStream.close();
        }
    }

    void addMavenArtifact(ClassifiedLocation key, IArtifactFacade artifact, Set<IInstallableUnit> units) {
        for (IInstallableUnit unit : units) {
            this.mavenInstallableUnits.put(unit, artifact);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("P2Resolver: artifact " + new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()).toString() + " resolves installable unit " + new VersionedId(unit.getId(), unit.getVersion()));
        }
    }

    public void publishAndAddArtifactIfBundleArtifact(IArtifactFacade artifact) {
        IInstallableUnit bundleIU = this.bundlesPublisher.attemptToPublishBundle(artifact);
        if (bundleIU != null) {
            this.addMavenArtifact(new ClassifiedLocation(artifact), artifact, Collections.singleton(bundleIU));
        }
    }

    public IArtifactRepository getSupplementaryArtifactRepository() {
        return this.bundlesPublisher.getArtifactRepoOfPublishedBundles();
    }

    public void addP2Repository(URI location) {
        IMetadataRepository metadataRepository = null;
        IArtifactRepository artifactRepository = null;
        metadataRepository = this.repositoryCache.getMetadataRepository(location);
        artifactRepository = this.repositoryCache.getArtifactRepository(location);
        if (metadataRepository != null && (this.offline || artifactRepository != null)) {
            this.metadataRepositories.add(metadataRepository);
            if (artifactRepository != null) {
                this.artifactRepositories.add(artifactRepository);
            }
            this.logger.info("Adding repository (cached) " + location.toASCIIString());
            return;
        }
        try {
            metadataRepository = this.metadataRepositoryManager.loadRepository(location, this.monitor);
            this.metadataRepositories.add(metadataRepository);
            if (!this.offline || URIUtil.isFileURI((URI)location)) {
                artifactRepository = this.artifactRepositoryManager.loadRepository(location, this.monitor);
                this.artifactRepositories.add(artifactRepository);
                this.forceSingleThreadedDownload(artifactRepository);
                if (this.disableP2Mirrors) {
                    this.forceMirrorsDisabled(artifactRepository);
                }
            }
            this.repositoryCache.putRepository(location, metadataRepository, artifactRepository);
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void forceSingleThreadedDownload(IArtifactRepository artifactRepository) {
        try {
            if (artifactRepository instanceof SimpleArtifactRepository) {
                OrderedProperties p = this.getProperties(artifactRepository);
                p.put("eclipse.p2.max.threads", "1");
            } else if (artifactRepository instanceof CompositeArtifactRepository) {
                List children = ((CompositeArtifactRepository)artifactRepository).getChildren();
                for (URI child : children) {
                    this.forceSingleThreadedDownload(this.artifactRepositoryManager.loadRepository(child, this.monitor));
                }
            }
        }
        catch (Exception exception) {}
    }

    private void forceMirrorsDisabled(IArtifactRepository artifactRepository) throws ProvisionException {
        if (artifactRepository instanceof SimpleArtifactRepository) {
            try {
                OrderedProperties p = this.getProperties(artifactRepository);
                p.remove((Object)"p2.mirrorsURL");
            }
            catch (Exception e) {
                throw new RuntimeException("Could not disable p2 mirrors", e);
            }
        } else if (artifactRepository instanceof CompositeArtifactRepository) {
            for (URI child : ((CompositeArtifactRepository)artifactRepository).getChildren()) {
                this.forceMirrorsDisabled(this.artifactRepositoryManager.loadRepository(child, this.monitor));
            }
        }
    }

    private OrderedProperties getProperties(IArtifactRepository artifactRepository) throws NoSuchFieldException, IllegalAccessException {
        Field field = AbstractRepository.class.getDeclaredField("properties");
        field.setAccessible(true);
        OrderedProperties p = (OrderedProperties)field.get((SimpleArtifactRepository)artifactRepository);
        return p;
    }

    public void addTargetDefinition(TargetDefinition definition, List<Map<String, String>> environments) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        TargetDefinitionResolver resolver = new TargetDefinitionResolver(environments, this.agent, this.logger);
        this.content.add(resolver.resolveContent(definition));
    }

    public void setCredentials(URI location, String username, String password) {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        String host = location.getHost();
        if (host == null) {
            String scheme = location.getScheme();
            host = URIUtil.isFileURI((URI)location) || scheme == null ? new Path(location.toString()).removeLastSegments(1).toString() : location.toString();
        }
        try {
            nodeKey = URLEncoder.encode(host, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                String enc = System.getProperty("file.encoding");
                if (enc == null) {
                    throw new UnsupportedEncodingException("No UTF-8 encoding and missing system property: file.encoding");
                }
                nodeKey = URLEncoder.encode(host, enc);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        String nodeName = "org.eclipse.equinox.p2.repository/" + nodeKey;
        ISecurePreferences prefNode = securePreferences.node(nodeName);
        try {
            if (!username.equals(prefNode.get("username", username)) || !password.equals(prefNode.get("password", password))) {
                this.logger.info("Redefining access credentials for repository host " + host);
            }
            prefNode.put("username", username, false);
            prefNode.put("password", password, false);
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
    }

    public IQueryable<IInstallableUnit> gatherAvailableInstallableUnits(IProgressMonitor monitor) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (TargetPlatformContent contentPart : this.content) {
            result.addAll(contentPart.getUnits());
        }
        result.addAll(this.mavenInstallableUnits.keySet());
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.metadataRepositories.size() * 200));
        for (IMetadataRepository repository : this.metadataRepositories) {
            IQueryResult matches = repository.query(QueryUtil.ALL_UNITS, (IProgressMonitor)sub.newChild(100));
            for (IInstallableUnit iu : matches) {
                if (ResolutionContextImpl.isPartialIU(iu)) {
                    this.logger.debug("PARTIAL IU: " + iu);
                    continue;
                }
                if (this.isReactorInstallableUnit(iu) || this.reactorInstallableUnitIds.contains(iu.getId())) continue;
                result.add(iu);
            }
        }
        result.addAll(this.createJREIUs());
        sub.done();
        return new QueryableArray(result.toArray(new IInstallableUnit[result.size()]));
    }

    public void warnAboutLocalIus(Collection<IInstallableUnit> usedIus) {
        Set localIUs = this.localMetadataRepository.query(QueryUtil.ALL_UNITS, null).toSet();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The following units are part of the target platform because they have been installed to the local repository:");
            for (IInstallableUnit unit : localIUs) {
                this.logger.debug("  " + unit.getId() + "/" + unit.getVersion());
            }
        }
        localIUs.retainAll(usedIus);
        if (!localIUs.isEmpty()) {
            this.logger.warn("The following locally built units have been used to resolve project dependencies:");
        }
        for (IInstallableUnit localIu : localIUs) {
            this.logger.warn("  " + localIu.getId() + "/" + localIu.getVersion());
        }
    }

    private static boolean isPartialIU(IInstallableUnit iu) {
        return Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu"));
    }

    private boolean isReactorInstallableUnit(IInstallableUnit iu) {
        return this.mavenInstallableUnits.get(iu) instanceof IReactorArtifactFacade;
    }

    private Collection<IInstallableUnit> createJREIUs() {
        PublisherResult results = new PublisherResult();
        new JREAction(null).perform((IPublisherInfo)new PublisherInfo(), (IPublisherResult)results, (IProgressMonitor)new NullProgressMonitor());
        return results.query(QueryUtil.ALL_UNITS, (IProgressMonitor)new NullProgressMonitor()).toSet();
    }

    public void downloadArtifacts(Collection<IInstallableUnit> newState) {
        List<MavenMirrorRequest> requests = new ArrayList<MavenMirrorRequest>();
        for (IInstallableUnit iu : newState) {
            if (this.getMavenArtifact(iu) != null) continue;
            Iterator<TargetPlatformContent> artifactKeys = iu.getArtifacts();
            Iterator<Object> iterator = artifactKeys.iterator();
            while (iterator.hasNext()) {
                IArtifactKey key = (IArtifactKey)iterator.next();
                requests.add(new MavenMirrorRequest(key, this.localRepository, this.getTransport()));
            }
        }
        CompositeArtifactRepository allArtifactRepositories = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.agent);
        for (IArtifactRepository artifactRepository : this.artifactRepositories) {
            allArtifactRepositories.addChild(artifactRepository.getLocation());
        }
        for (TargetPlatformContent contentPart : this.content) {
            Collection<URI> repos = contentPart.getArtifactRepositoryLocations();
            for (URI repo : repos) {
                allArtifactRepositories.addChild(repo);
            }
        }
        IStatus result = allArtifactRepositories.getArtifacts(requests.toArray(ARTIFACT_REQUEST_ARRAY), this.monitor);
        if (!result.isOK()) {
            throw new RuntimeException(StatusTool.collectProblems((IStatus)result), result.getException());
        }
        requests = this.filterCompletedRequests(requests);
        this.localRepository.save();
        this.localMetadataRepository.save();
        Iterator<MavenMirrorRequest> iter = requests.iterator();
        while (iter.hasNext()) {
            MavenMirrorRequest request = iter.next();
            if (!this.localRepository.contains(request.getArtifactKey())) continue;
            iter.remove();
        }
        if (!requests.isEmpty()) {
            StringBuilder msg = new StringBuilder("Could not download artifacts from any repository\n");
            for (MavenMirrorRequest request : requests) {
                msg.append("   ").append(request.getArtifactKey().toExternalForm()).append('\n');
            }
            throw new RuntimeException(msg.toString());
        }
    }

    private List<MavenMirrorRequest> filterCompletedRequests(List<MavenMirrorRequest> requests) {
        ArrayList<MavenMirrorRequest> filteredRequests = new ArrayList<MavenMirrorRequest>();
        for (MavenMirrorRequest request : requests) {
            if (request.getResult() != null && request.getResult().isOK()) continue;
            filteredRequests.add(request);
        }
        return filteredRequests;
    }

    public void assertNoDuplicateReactorUIs() throws DuplicateReactorIUsException {
        HashMap<IInstallableUnit, LinkedHashSet<File>> reactorUIs = new HashMap<IInstallableUnit, LinkedHashSet<File>>();
        HashMap<IInstallableUnit, Set<File>> duplicateReactorUIs = new HashMap<IInstallableUnit, Set<File>>();
        for (Map.Entry<ClassifiedLocation, Set<IInstallableUnit>> entry : this.reactorProjectIUs.entrySet()) {
            for (IInstallableUnit iu : entry.getValue()) {
                LinkedHashSet<File> locations = (LinkedHashSet<File>)reactorUIs.get(iu);
                if (locations == null) {
                    locations = new LinkedHashSet<File>();
                    reactorUIs.put(iu, locations);
                }
                locations.add(entry.getKey().getLocation());
                if (locations.size() <= 1) continue;
                duplicateReactorUIs.put(iu, locations);
            }
        }
        if (!duplicateReactorUIs.isEmpty()) {
            throw new DuplicateReactorIUsException(duplicateReactorUIs);
        }
    }

    public LinkedHashSet<IInstallableUnit> getReactorProjectIUs(File projectRoot) {
        LinkedHashSet<IInstallableUnit> ius = new LinkedHashSet<IInstallableUnit>();
        boolean projectExists = false;
        for (Map.Entry<ClassifiedLocation, Set<IInstallableUnit>> entry : this.reactorProjectIUs.entrySet()) {
            if (!projectRoot.equals(entry.getKey().getLocation())) continue;
            ius.addAll((Collection<IInstallableUnit>)entry.getValue());
            projectExists = true;
        }
        if (!projectExists) {
            throw new IllegalArgumentException("Not a reactor project: " + projectRoot);
        }
        return ius;
    }

    public IArtifactFacade getMavenArtifact(IInstallableUnit iu) {
        return this.mavenInstallableUnits.get(iu);
    }

    public File getLocalArtifactFile(IArtifactKey key) {
        return this.localRepository.getArtifactFile(key);
    }

    protected Transport getTransport() {
        return (Transport)this.agent.getService(Transport.SERVICE_NAME);
    }
}

