/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.impl.resolver;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;

public class TychoP2RepositoryCacheManager
extends CacheManager {
    public static final String CACHE_RELPATH = ".cache/tycho/p2-repository-metadata";
    private boolean offline;
    private File localRepositoryLocation;

    public TychoP2RepositoryCacheManager(Transport transport) {
        super(null, transport);
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        File cacheFile = this.getCache(repositoryLocation, prefix);
        if (this.offline) {
            if (cacheFile != null) {
                return cacheFile;
            }
            throw new ProvisionException("Repository system is offline and no local cache available for " + repositoryLocation.toString());
        }
        return super.createCache(repositoryLocation, prefix, monitor);
    }

    protected File getCacheDirectory() {
        return new File(this.localRepositoryLocation, CACHE_RELPATH);
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setLocalRepositoryLocation(File localRepositoryLocation) {
        this.localRepositoryLocation = localRepositoryLocation;
    }
}

