/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.target;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.target.TargetPlatformContent;
import org.eclipse.tycho.p2.target.facade.TargetDefinition;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionResolutionException;
import org.eclipse.tycho.p2.target.facade.TargetDefinitionSyntaxException;
import org.eclipse.tycho.p2.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetDefinitionResolver {
    private static final IInstallableUnit[] EMPTY_IU_ARRAY = new IInstallableUnit[0];
    private IMetadataRepositoryManager metadataManager;
    private final MavenLogger logger;
    private final List<Map<String, String>> environments;

    public TargetDefinitionResolver(List<Map<String, String>> environments, IProvisioningAgent agent, MavenLogger logger) {
        this.environments = environments;
        this.logger = logger;
        this.metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    public TargetPlatformContent resolveContent(TargetDefinition definition) throws TargetDefinitionSyntaxException, TargetDefinitionResolutionException {
        ArrayList<URI> artifactRepositories = new ArrayList<URI>();
        IUResolver resolverRun = new IUResolver();
        for (TargetDefinition.Location locationDefinition : definition.getLocations()) {
            if (locationDefinition instanceof TargetDefinition.InstallableUnitLocation) {
                TargetDefinition.InstallableUnitLocation iuLocationDefinition = (TargetDefinition.InstallableUnitLocation)locationDefinition;
                resolverRun.addLocation(iuLocationDefinition);
                for (TargetDefinition.Repository repository : iuLocationDefinition.getRepositories()) {
                    artifactRepositories.add(repository.getLocation());
                }
                continue;
            }
            this.logger.warn(NLS.bind((String)"Target location type: {0} is not supported", (Object)locationDefinition.getTypeDescription()));
        }
        return new ResolvedDefinition(resolverRun.execute(), artifactRepositories);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IUResolver {
        private List<LoadedLocation> locations = new ArrayList<LoadedLocation>();
        List<IQueryable<IInstallableUnit>> availableUnits = new ArrayList<IQueryable<IInstallableUnit>>();
        List<IInstallableUnit> seedUnits = new ArrayList<IInstallableUnit>();
        private TargetDefinition.IncludeMode includeMode = null;
        private Boolean includeAllEnvironments = null;

        private IUResolver() {
        }

        void addLocation(TargetDefinition.InstallableUnitLocation locationDefinition) {
            this.setIncludeMode(locationDefinition.getIncludeMode());
            this.setIncludeAllEnvironments(locationDefinition.includeAllEnvironments());
            LoadedLocation loadedLocation = new LoadedLocation(locationDefinition);
            this.locations.add(loadedLocation);
            this.availableUnits.add(loadedLocation.getAvailableUnits());
            this.seedUnits.addAll(loadedLocation.getSeedUnits());
        }

        private void setIncludeAllEnvironments(Boolean newValue) {
            if (!newValue.equals(this.includeAllEnvironments)) {
                if (this.includeAllEnvironments != null) {
                    throw new TargetDefinitionResolutionException("The attribute 'includeAllPlatforms' must be the same for all locations");
                }
                this.includeAllEnvironments = newValue;
            }
        }

        private void setIncludeMode(TargetDefinition.IncludeMode newValue) {
            if (this.includeMode != newValue) {
                if (this.includeMode != null) {
                    throw new TargetDefinitionResolutionException("Include mode must be the same for all locations");
                }
                this.includeMode = newValue;
            }
        }

        Collection<IInstallableUnit> execute() {
            Collection<IInstallableUnit> resolvedUnits;
            if (this.locations.isEmpty()) {
                return Collections.emptyList();
            }
            switch (this.includeMode) {
                case PLANNER: {
                    resolvedUnits = this.resolveWithPlanner();
                    break;
                }
                case SLICER: {
                    resolvedUnits = this.resolveWithSlicer();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return resolvedUnits;
        }

        private Collection<IInstallableUnit> resolveWithSlicer() {
            IQueryable availableUnitsQueryable = QueryUtil.compoundQueryable(this.availableUnits);
            HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
            if (this.includeAllEnvironments.booleanValue()) {
                Map<String, String> selectionContext = Collections.emptyMap();
                result.addAll(this.sliceForPlatform(this.seedUnits, (IQueryable<IInstallableUnit>)availableUnitsQueryable, selectionContext));
            } else {
                for (Map environment : TargetDefinitionResolver.this.environments) {
                    Map<String, String> selectionContext = this.addFeatureJarFilter(environment);
                    result.addAll(this.sliceForPlatform(this.seedUnits, (IQueryable<IInstallableUnit>)availableUnitsQueryable, selectionContext));
                }
            }
            return result;
        }

        private Set<IInstallableUnit> sliceForPlatform(List<IInstallableUnit> seedUnits, IQueryable<IInstallableUnit> availableUnits, Map<String, String> selectionContext) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            boolean evalFilterTo = selectionContext.isEmpty();
            PermissiveSlicer slicer = new PermissiveSlicer(availableUnits, selectionContext, true, false, evalFilterTo, true, false);
            IQueryable slice = slicer.slice(seedUnits.toArray(EMPTY_IU_ARRAY), (IProgressMonitor)monitor);
            MultiStatus slicerStatus = slicer.getStatus();
            if (slicerStatus.matches(14)) {
                throw new TargetDefinitionResolutionException(StatusTool.collectProblems((IStatus)slicerStatus), StatusTool.findException((IStatus)slicer.getStatus()));
            }
            return slice.query(QueryUtil.ALL_UNITS, (IProgressMonitor)monitor).toSet();
        }

        private Map<String, String> addFeatureJarFilter(Map<String, String> environment) {
            HashMap<String, String> selectionContext = new HashMap<String, String>(environment);
            selectionContext.put("org.eclipse.update.install.features", "true");
            return selectionContext;
        }

        private Collection<IInstallableUnit> resolveWithPlanner() {
            IQueryable availableUnitsQueryable = QueryUtil.compoundQueryable(this.availableUnits);
            HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
            for (Map environment : TargetDefinitionResolver.this.environments) {
                Map<String, String> selectionContext = this.addFeatureJarFilter(environment);
                Collection<IInstallableUnit> resolvedUnits = this.planForPlatform(this.seedUnits, (IQueryable<IInstallableUnit>)availableUnitsQueryable, selectionContext);
                result.addAll(resolvedUnits);
            }
            return result;
        }

        private Collection<IInstallableUnit> planForPlatform(List<IInstallableUnit> seedUnits, IQueryable<IInstallableUnit> availableUnits, Map<String, String> selectionContext) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            Slicer slicer = new Slicer(availableUnits, selectionContext, false);
            IQueryable slice = slicer.slice(seedUnits.toArray(EMPTY_IU_ARRAY), (IProgressMonitor)monitor);
            if (slice == null) {
                MultiStatus slicerStatus = slicer.getStatus();
                throw new TargetDefinitionResolutionException(StatusTool.collectProblems((IStatus)slicerStatus), StatusTool.findException((IStatus)slicer.getStatus()));
            }
            Projector projector = new Projector(slice, selectionContext, new HashSet(), false);
            projector.encode(this.createMetaIU(seedUnits), EMPTY_IU_ARRAY, (IQueryable)new QueryableArray(EMPTY_IU_ARRAY), seedUnits, (IProgressMonitor)monitor);
            IStatus s = projector.invokeSolver((IProgressMonitor)monitor);
            if (s.getSeverity() == 4) {
                Set explanation = projector.getExplanation((IProgressMonitor)monitor);
                TargetDefinitionResolver.this.logger.error("Cannot resolve target definition file:");
                for (Explanation explanationLine : explanation) {
                    TargetDefinitionResolver.this.logger.error("  " + explanationLine.toString());
                }
                TargetDefinitionResolver.this.logger.error("");
                throw new TargetDefinitionResolutionException(explanation.toString());
            }
            Collection resolvedUnits = projector.extractSolution();
            return resolvedUnits;
        }

        private IInstallableUnit createMetaIU(Collection<IInstallableUnit> rootIUs) {
            MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
            String time = Long.toString(System.currentTimeMillis());
            iud.setId(time);
            iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
            ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
            for (IInstallableUnit iu : rootIUs) {
                VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
                requirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (int)1, (int)(iu.isSingleton() ? 1 : Integer.MAX_VALUE), (boolean)true));
            }
            iud.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
            return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadedLocation {
        private final TargetDefinition.InstallableUnitLocation location;
        private IQueryable<IInstallableUnit> repositoryUnits;

        LoadedLocation(TargetDefinition.InstallableUnitLocation location) {
            this.location = location;
            List repositories = location.getRepositories();
            ArrayList<IMetadataRepository> loadedRepositories = new ArrayList<IMetadataRepository>();
            for (TargetDefinition.Repository repository : repositories) {
                IMetadataRepository loadedRepository = this.loadRepository(repository);
                loadedRepositories.add(loadedRepository);
            }
            this.repositoryUnits = loadedRepositories.size() == 1 ? (IQueryable)loadedRepositories.get(0) : QueryUtil.compoundQueryable(loadedRepositories);
        }

        private IMetadataRepository loadRepository(TargetDefinition.Repository repository) {
            try {
                return TargetDefinitionResolver.this.metadataManager.loadRepository(repository.getLocation(), null);
            }
            catch (ProvisionException e) {
                throw new TargetDefinitionResolutionException("Failed to load metadata repository from location " + repository.getLocation(), (Throwable)e);
            }
        }

        IQueryable<IInstallableUnit> getAvailableUnits() {
            return this.repositoryUnits;
        }

        Set<IInstallableUnit> getSeedUnits() {
            HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
            for (TargetDefinition.Unit unit : this.location.getUnits()) {
                result.add(this.getUnitInstance(unit));
            }
            return result;
        }

        private IInstallableUnit getUnitInstance(TargetDefinition.Unit unitReference) {
            IQueryResult<IInstallableUnit> queryResult = this.searchUnitInThisLocation(unitReference);
            if (queryResult.isEmpty()) {
                throw new TargetDefinitionResolutionException(NLS.bind((String)"Could not find \"{0}/{1}\" in the repositories of the current location", (Object)unitReference.getId(), (Object)unitReference.getVersion()));
            }
            IInstallableUnit unitInstance = (IInstallableUnit)queryResult.iterator().next();
            return unitInstance;
        }

        private IQueryResult<IInstallableUnit> searchUnitInThisLocation(TargetDefinition.Unit unitReference) {
            Version version = this.parseVersion(unitReference);
            IQuery matchingIUQuery = QueryUtil.createIUQuery((String)unitReference.getId(), (Version)version);
            IQuery latestMatchingIUQuery = QueryUtil.createLatestQuery((IQuery)matchingIUQuery);
            IQueryResult queryResult = this.repositoryUnits.query(latestMatchingIUQuery, null);
            return queryResult;
        }

        private Version parseVersion(TargetDefinition.Unit unitReference) {
            try {
                return Version.parseVersion((String)unitReference.getVersion());
            }
            catch (IllegalArgumentException e) {
                throw new TargetDefinitionSyntaxException(NLS.bind((String)"Cannot parse version \"{0}\" of unit \"{1}\"", (Object)unitReference.getVersion(), (Object)unitReference.getId()), (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolvedDefinition
    implements TargetPlatformContent {
        private Collection<? extends IInstallableUnit> units;
        private Collection<URI> artifactRepositories;

        public ResolvedDefinition(Collection<? extends IInstallableUnit> units, Collection<URI> artifactRepositories) {
            this.units = units;
            this.artifactRepositories = artifactRepositories;
        }

        @Override
        public Collection<? extends IInstallableUnit> getUnits() {
            return this.units;
        }

        @Override
        public Collection<URI> getArtifactRepositoryLocations() {
            return this.artifactRepositories;
        }
    }
}

