/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.repository;

import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenRepositoryCoordinates {
    public static final String DEFAULT_EXTENSION = "jar";
    private final GAV gav;
    private final String classifier;
    private final String extension;

    public MavenRepositoryCoordinates(GAV gav, String classifier, String extension) {
        this.gav = gav;
        this.classifier = classifier;
        this.extension = DEFAULT_EXTENSION.equals(extension) ? null : extension;
    }

    public MavenRepositoryCoordinates(String groupId, String artifactId, String version, String classifier, String extension) {
        this(new GAV(groupId, artifactId, version), classifier, extension);
    }

    public GAV getGav() {
        return this.gav;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getExtensionOrDefault() {
        if (this.extension == null) {
            return DEFAULT_EXTENSION;
        }
        return this.extension;
    }

    public String getLocalRepositoryPath() {
        return RepositoryLayoutHelper.getRelativePath(this.getGav(), this.getClassifier(), this.getExtension());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getGroupId());
        result.append(':');
        result.append(this.getArtifactId());
        result.append(':');
        result.append(this.getExtensionOrDefault());
        if (this.getClassifier() != null) {
            result.append(':');
            result.append(this.getClassifier());
        }
        result.append(':');
        result.append(this.getVersion());
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.gav == null ? 0 : this.gav.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenRepositoryCoordinates)) {
            return false;
        }
        MavenRepositoryCoordinates other = (MavenRepositoryCoordinates)obj;
        return MavenRepositoryCoordinates.eq(this.gav, other.gav) && MavenRepositoryCoordinates.eq(this.classifier, other.classifier) && MavenRepositoryCoordinates.eq(this.extension, other.extension);
    }

    private static <T> boolean eq(T left, T right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }
}

