/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.publisher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.internal.p2.updatesite.CategoryXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.resolver.shared.DependencySeed;
import org.eclipse.tycho.p2.target.ee.CustomEEResolutionHints;
import org.eclipse.tycho.p2.tools.BuildContext;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.publisher.DependencySeedUtil;
import org.eclipse.tycho.p2.tools.publisher.ProductBinariesWriteSession;
import org.eclipse.tycho.p2.tools.publisher.PublisherInfoTemplate;
import org.eclipse.tycho.p2.tools.publisher.ResultSpyAction;
import org.eclipse.tycho.p2.tools.publisher.facade.PublisherService;
import org.eclipse.tycho.repository.publishing.PublishingRepository;
import org.eclipse.tycho.repository.publishing.WriteSessionContext;
import org.eclipse.tycho.repository.util.StatusTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PublisherServiceImpl
implements PublisherService {
    private final BuildContext context;
    private final PublisherInfoTemplate configuration;
    private final PublishingRepository publishingRepository;
    private final MavenLogger logger;

    public PublisherServiceImpl(BuildContext context, PublisherInfoTemplate publisherConfiguration, PublishingRepository publishingRepository, MavenLogger logger) {
        this.context = context;
        this.configuration = publisherConfiguration;
        this.publishingRepository = publishingRepository;
        this.logger = logger;
    }

    public Collection<DependencySeed> publishCategories(File categoryDefinition) throws FacadeException, IllegalStateException {
        CategoryXMLAction categoryXMLAction = new CategoryXMLAction(categoryDefinition.toURI(), this.context.getQualifier());
        Collection<IInstallableUnit> allIUs = this.executePublisher((IPublisherAction)categoryXMLAction, this.publishingRepository.getMetadataRepository(), this.publishingRepository.getArtifactRepository());
        return PublisherServiceImpl.toSeeds(null, allIUs);
    }

    public Collection<DependencySeed> publishProduct(File productDefinition, File launcherBinaries, String flavor) throws FacadeException, IllegalStateException {
        ProductFile productDescriptor = null;
        try {
            productDescriptor = new ProductFile(productDefinition.getAbsolutePath());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load product file " + productDefinition.getAbsolutePath(), e);
        }
        ProductAction action = new ProductAction(null, (IProductDescriptor)productDescriptor, flavor, launcherBinaries);
        IMetadataRepository metadataRepository = this.publishingRepository.getMetadataRepository();
        IArtifactRepository artifactRepository = this.publishingRepository.getArtifactRepositoryForWriting((WriteSessionContext)new ProductBinariesWriteSession(productDescriptor.getId()));
        Collection<IInstallableUnit> allIUs = this.executePublisher((IPublisherAction)action, metadataRepository, artifactRepository);
        return Collections.singletonList(DependencySeedUtil.createSeed("eclipse-product", PublisherServiceImpl.selectUnit(allIUs, productDescriptor.getId())));
    }

    public Collection<DependencySeed> publishEEProfile(File profileFile) throws FacadeException {
        this.validateProfile(profileFile);
        JREAction jreAction = new JREAction(profileFile);
        Collection<IInstallableUnit> allIUs = this.executePublisher((IPublisherAction)jreAction, this.publishingRepository.getMetadataRepository(), this.publishingRepository.getArtifactRepository());
        return PublisherServiceImpl.toSeeds(null, allIUs);
    }

    void validateProfile(File profileFile) throws FacadeException {
        Properties profileProperties = new Properties();
        try {
            FileInputStream stream = new FileInputStream(profileFile);
            try {
                profileProperties.load(stream);
                this.validateProfile(profileProperties, profileFile);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new FacadeException((Throwable)e);
        }
    }

    private void validateProfile(Properties props, File profileFile) throws FacadeException {
        String simpleFileName = profileFile.getName();
        if (!simpleFileName.endsWith(".profile")) {
            throw new FacadeException("Profile file name must end with '.profile': " + profileFile);
        }
        String profileNameKey = "osgi.java.profile.name";
        String profileName = props.getProperty(profileNameKey);
        if (profileName == null) {
            throw new FacadeException("Mandatory property '" + profileNameKey + "' is missing in profile file " + profileFile);
        }
        new CustomEEResolutionHints(profileName);
        String fileNamePrefix = simpleFileName.substring(0, simpleFileName.length() - ".profile".length()).toLowerCase(Locale.ENGLISH);
        if (!fileNamePrefix.equals(profileName.toLowerCase(Locale.ENGLISH))) {
            throw new FacadeException("Profile file with 'osgi.java.profile.name=" + profileName + "' must be named '" + profileName + ".profile', but found file name: '" + simpleFileName + "'");
        }
    }

    private Collection<IInstallableUnit> executePublisher(IPublisherAction action, IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) throws FacadeException {
        ResultSpyAction resultSpy = new ResultSpyAction();
        IPublisherAction[] actions = new IPublisherAction[]{action, resultSpy};
        Publisher publisher = new Publisher(this.configuration.newPublisherInfo(metadataRepository, artifactRepository));
        IStatus result = publisher.publish(actions, null);
        this.handlePublisherStatus(result);
        return resultSpy.getAllIUs();
    }

    private void handlePublisherStatus(IStatus result) throws FacadeException {
        if (result.matches(1)) {
            this.logger.info(StatusTool.collectProblems((IStatus)result));
        } else if (result.matches(2)) {
            this.logger.warn(StatusTool.collectProblems((IStatus)result));
        } else if (!result.isOK()) {
            throw new FacadeException(StatusTool.collectProblems((IStatus)result), result.getException());
        }
    }

    private static IInstallableUnit selectUnit(Collection<IInstallableUnit> units, String id) {
        for (IInstallableUnit unit : units) {
            if (!id.equals(unit.getId())) continue;
            return unit;
        }
        throw new AssertionFailedException("Publisher did not produce expected IU");
    }

    private static Collection<DependencySeed> toSeeds(String type, Collection<IInstallableUnit> units) {
        ArrayList<DependencySeed> result = new ArrayList<DependencySeed>(units.size());
        for (IInstallableUnit unit : units) {
            result.add(DependencySeedUtil.createSeed(type, unit));
        }
        return result;
    }
}

