/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.verifier;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.core.facade.MavenContext;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.impl.Activator;
import org.eclipse.tycho.p2.tools.verifier.facade.VerifierService;

public class VerifierServiceImpl
implements VerifierService {
    private final NullProgressMonitor monitor = new NullProgressMonitor();
    private MavenContext mavenContext;

    public boolean verify(URI metadataRepositoryUri, URI artifactRepositoryUri, BuildOutputDirectory tempDirectory) throws FacadeException {
        MavenLogger logger = this.mavenContext.getLogger();
        logger.debug("Checking metadata from '" + metadataRepositoryUri + "' and artifacts from '" + artifactRepositoryUri + "'");
        IProvisioningAgent agent = Activator.createProvisioningAgent(tempDirectory);
        try {
            IMetadataRepository metadata = this.loadMetadataRepository(metadataRepositoryUri, agent);
            IArtifactRepository artifactRepository = this.loadArtifactRepository(artifactRepositoryUri, agent);
            boolean valid = true;
            valid &= this.verifyReferencedArtifactsExist(metadata, artifactRepository, logger);
            if (valid &= this.verifyAllArtifactContent(artifactRepository, logger)) {
                logger.info("The integrity of the metadata repository '" + metadataRepositoryUri + "' and artifact repository '" + artifactRepositoryUri + "' has been verified successfully");
            }
            boolean bl = valid;
            return bl;
        }
        catch (ProvisionException e) {
            throw new FacadeException((Throwable)e);
        }
        finally {
            agent.stop();
        }
    }

    private boolean verifyReferencedArtifactsExist(IMetadataRepository metadata, IArtifactRepository artifactRepository, MavenLogger logger) {
        IQueryResult collector = metadata.query(QueryUtil.ALL_UNITS, (IProgressMonitor)this.monitor);
        boolean valid = true;
        for (IInstallableUnit iu : collector) {
            Collection artifacts = iu.getArtifacts();
            for (IArtifactKey key : artifacts) {
                valid &= this.verifyArtifactExists(key, artifactRepository, logger);
            }
        }
        return valid;
    }

    private boolean verifyArtifactExists(IArtifactKey key, IArtifactRepository repository, MavenLogger logger) {
        IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(key);
        if (descriptors.length == 0) {
            logger.error("Missing artifact: " + key);
            return false;
        }
        return true;
    }

    private boolean verifyAllArtifactContent(IArtifactRepository repository, MavenLogger logger) {
        boolean valid = true;
        IQueryResult allKeys = repository.query((IQuery)new ExpressionMatchQuery(IArtifactKey.class, ExpressionUtil.TRUE_EXPRESSION, new Object[0]), null);
        for (IArtifactKey key : allKeys) {
            IArtifactDescriptor[] descriptors;
            IArtifactDescriptor[] iArtifactDescriptorArray = descriptors = repository.getArtifactDescriptors(key);
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                valid &= this.verifyArtifactContent(repository, logger, descriptor);
                ++n2;
            }
        }
        return valid;
    }

    private boolean verifyArtifactContent(IArtifactRepository repository, MavenLogger logger, IArtifactDescriptor descriptor) {
        IStatus status = repository.getArtifact(descriptor, (OutputStream)new ByteArrayOutputStream(), (IProgressMonitor)this.monitor);
        if (!status.isOK()) {
            this.logErrorStatus(status, "", logger);
        }
        return status.isOK();
    }

    private void logErrorStatus(IStatus status, String indent, MavenLogger logger) {
        Throwable exception = status.getException();
        if (exception == null) {
            logger.error(String.valueOf(indent) + status.getMessage());
        } else {
            logger.error(String.valueOf(indent) + status.getMessage() + ": " + exception.getLocalizedMessage());
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus kid = iStatusArray[n2];
            this.logErrorStatus(kid, String.valueOf(indent) + "  ", logger);
            ++n2;
        }
    }

    private IMetadataRepository loadMetadataRepository(URI metadataRepository, IProvisioningAgent agent) throws ProvisionException {
        IMetadataRepositoryManager repositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        return repositoryManager.loadRepository(metadataRepository, (IProgressMonitor)this.monitor);
    }

    private IArtifactRepository loadArtifactRepository(URI artifactRepository, IProvisioningAgent agent) throws ProvisionException {
        IArtifactRepositoryManager repositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        return repositoryManager.loadRepository(artifactRepository, (IProgressMonitor)this.monitor);
    }

    public void setMavenContext(MavenContext mavenContext) {
        this.mavenContext = mavenContext;
    }
}

