/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.equinox.embedder;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.eclipse.tycho.equinox.EquinoxRuntimeLocator;
import org.eclipse.tycho.equinox.embedder.EquinoxEmbedder;
import org.eclipse.tycho.equinox.embedder.EquinoxLifecycleListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EquinoxEmbedder.class)
public class DefaultEquinoxEmbedder
extends AbstractLogEnabled
implements EquinoxEmbedder {
    @Requirement(role=EquinoxLifecycleListener.class)
    private Map<String, EquinoxLifecycleListener> lifecycleListeners;
    @Requirement
    private EquinoxRuntimeLocator equinoxLocator;
    private BundleContext frameworkContext;
    private String[] nonFrameworkArgs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() throws Exception {
        if (this.frameworkContext != null) {
            return;
        }
        if ("Eclipse".equals(System.getProperty("org.osgi.framework.vendor"))) {
            throw new IllegalStateException("Nested Equinox instance is not supported");
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            this.doStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    protected void doStart() throws Exception {
        List locations = this.equinoxLocator.getRuntimeLocations();
        if (locations == null || locations.isEmpty() || !((File)locations.get(0)).isDirectory()) {
            throw new RuntimeException("Equinox runtime location is missing or invalid");
        }
        File frameworkDir = (File)locations.get(0);
        String frameworkLocation = frameworkDir.getAbsolutePath();
        System.setProperty("osgi.framework.useSystemProperties", "false");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osgi.install.area", frameworkLocation);
        properties.put("osgi.syspath", frameworkLocation + "/plugins");
        properties.put("osgi.configuration.area", frameworkLocation + "/configuration");
        StringBuilder bundles = new StringBuilder();
        this.addBundlesDir(bundles, new File(frameworkDir, "plugins").listFiles(), false);
        for (int i = 1; i < locations.size(); ++i) {
            File location = (File)locations.get(i);
            if (location.isDirectory()) {
                this.addBundlesDir(bundles, location.listFiles(), true);
                continue;
            }
            bundles.append(',').append(this.getReferenceUrl(location));
        }
        properties.put("osgi.bundles", bundles.toString());
        properties.put("osgi.parentClassloader", "fwk");
        List packagesExtra = this.equinoxLocator.getSystemPackagesExtra();
        if (packagesExtra.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String pkg : packagesExtra) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(pkg);
            }
            properties.put("org.osgi.framework.system.packages.extra", sb.toString());
        }
        EclipseStarter.setInitialProperties(properties);
        EclipseStarter.startup((String[])(this.nonFrameworkArgs != null ? this.nonFrameworkArgs : new String[]{}), null);
        this.frameworkContext = EclipseStarter.getSystemBundleContext();
        PackageAdmin packageAdmin = null;
        ServiceReference packageAdminRef = this.frameworkContext.getServiceReference(PackageAdmin.class.getName());
        if (packageAdminRef != null) {
            packageAdmin = (PackageAdmin)this.frameworkContext.getService(packageAdminRef);
        }
        if (packageAdmin == null) {
            throw new IllegalStateException("Could not obtain PackageAdmin service");
        }
        for (Bundle bundle : this.frameworkContext.getBundles()) {
            if ((packageAdmin.getBundleType(bundle) & 1) != 0) continue;
            try {
                bundle.start();
            }
            catch (BundleException e) {
                this.getLogger().warn("Could not start bundle " + bundle.getSymbolicName(), (Throwable)e);
            }
        }
        this.frameworkContext.ungetService(packageAdminRef);
        for (EquinoxLifecycleListener listener : this.lifecycleListeners.values()) {
            listener.afterFrameworkStarted(this);
        }
    }

    private void addBundlesDir(StringBuilder bundles, File[] files, boolean absolute) {
        if (files != null) {
            for (File file : files) {
                if (file.getName().startsWith("org.eclipse.osgi_")) continue;
                if (bundles.length() > 0) {
                    bundles.append(',');
                }
                if (absolute) {
                    bundles.append(this.getReferenceUrl(file));
                } else {
                    String name = file.getName();
                    int verIdx = name.indexOf(95);
                    if (verIdx > 0) {
                        bundles.append(name.substring(0, verIdx));
                    }
                }
                if (!file.getName().startsWith("org.eclipse.equinox.ds_")) continue;
                bundles.append("@1:start");
            }
        }
    }

    String getReferenceUrl(File file) {
        return "reference:file:" + file.getAbsoluteFile().toURI().normalize().getPath();
    }

    @Override
    public <T> T getService(Class<T> clazz) {
        return this.getService(clazz, null);
    }

    @Override
    public <T> T getService(Class<T> clazz, String filter) {
        ServiceReference[] serviceReferences;
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            serviceReferences = this.frameworkContext.getServiceReferences(clazz.getName(), filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (serviceReferences == null || serviceReferences.length == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Service is not registered class='").append(clazz).append("'");
            if (filter != null) {
                sb.append("filter='").append(filter).append("'");
            }
            throw new IllegalStateException(sb.toString());
        }
        return clazz.cast(this.frameworkContext.getService(serviceReferences[0]));
    }

    @Override
    public void setNonFrameworkArgs(String[] args) {
        if (this.frameworkContext != null) {
            throw new IllegalStateException("Cannot set non-framework arguments after the framework was started");
        }
        this.nonFrameworkArgs = args;
    }
}

