/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher;

import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.tycho.BuildOutputDirectory;
import org.eclipse.tycho.ReactorProjectCoordinates;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.osgi.adapters.MavenReactorProjectCoordinates;
import org.eclipse.tycho.p2.tools.BuildContext;

public abstract class AbstractP2Mojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private String qualifier;

    protected MavenProject getProject() {
        return this.project;
    }

    protected ReactorProjectCoordinates getProjectCoordinates() {
        return new MavenReactorProjectCoordinates(this.project);
    }

    protected MavenSession getSession() {
        return this.session;
    }

    protected String getQualifier() {
        return this.qualifier;
    }

    protected BuildOutputDirectory getBuildDirectory() {
        return this.getProjectCoordinates().getBuildDirectory();
    }

    protected EclipseRepositoryProject getEclipseRepositoryProject() {
        return (EclipseRepositoryProject)this.getTychoProjectFacet("eclipse-repository");
    }

    private TychoProject getTychoProjectFacet(String packaging) {
        TychoProject facet;
        try {
            facet = (TychoProject)this.session.lookup(TychoProject.class.getName(), packaging);
        }
        catch (ComponentLookupException e) {
            throw new IllegalStateException("Could not lookup required component", e);
        }
        return facet;
    }

    protected BuildContext getBuildContext() {
        List environments = TychoProjectUtils.getTargetPlatformConfiguration((MavenProject)this.project).getEnvironments();
        return new BuildContext(this.getProjectCoordinates(), this.getQualifier(), environments);
    }
}

