/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.publisher.persistence;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.plugins.p2.publisher.AbstractP2Mojo;
import org.eclipse.tycho.repository.registry.facade.PublishingRepositoryFacade;
import org.eclipse.tycho.repository.registry.facade.ReactorRepositoryManagerFacade;

public class AttachPublishedArtifactsMojo
extends AbstractP2Mojo {
    private MavenProjectHelper projectHelper;
    private EquinoxServiceFactory osgiServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.getProject());
        ReactorRepositoryManagerFacade reactorRepoManager = (ReactorRepositoryManagerFacade)this.osgiServices.getService(ReactorRepositoryManagerFacade.class);
        PublishingRepositoryFacade publishingRepo = reactorRepoManager.getPublishingRepository(this.getProjectCoordinates());
        Map artifacts = publishingRepo.getArtifactLocations();
        for (Map.Entry entry : artifacts.entrySet()) {
            String classifier = (String)entry.getKey();
            File artifactLocation = (File)entry.getValue();
            if (classifier == null) {
                this.getProject().getArtifact().setFile(artifactLocation);
                continue;
            }
            String type = AttachPublishedArtifactsMojo.getExtension(artifactLocation);
            this.projectHelper.attachArtifact(this.getProject(), type, classifier, artifactLocation);
            reactorProject.setDependencyMetadata(classifier, true, Collections.emptySet());
            reactorProject.setDependencyMetadata(classifier, false, Collections.emptySet());
        }
        reactorProject.setDependencyMetadata(null, true, publishingRepo.getInstallableUnits());
        reactorProject.setDependencyMetadata(null, false, Collections.emptySet());
    }

    private static String getExtension(File file) {
        String fileName = file.getName();
        int separator = fileName.lastIndexOf(46);
        if (separator < 0) {
            throw new IllegalArgumentException("No file extension in \"" + fileName + "\"");
        }
        return fileName.substring(separator + 1);
    }
}

