/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.compile.CompileService;
import com.greenpineyu.fel.compile.FelCompiler;
import com.greenpineyu.fel.compile.FelCompilerClassloader;
import com.greenpineyu.fel.compile.FelJavaFileObject;
import com.greenpineyu.fel.compile.JavaSource;
import com.greenpineyu.fel.exception.CompileException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelCompiler16<T>
implements FelCompiler {
    private final FelCompilerClassloader classLoader;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> options;
    private DiagnosticCollector<JavaFileObject> diagnostics;
    private final JavaFileManager javaFileManager;

    public FelCompiler16() {
        if (this.compiler == null) {
            throw new IllegalStateException("Cannot find the system Java compiler. Check that your class path includes tools.jar");
        }
        this.classLoader = new FelCompilerClassloader(this.getClass().getClassLoader());
        this.diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        ClassLoader loader = this.classLoader.getParent();
        List<String> paths = CompileService.getClassPath(loader);
        ArrayList<File> cpFiles = new ArrayList<File>();
        if (paths != null && !paths.isEmpty()) {
            for (String file : paths) {
                cpFiles.add(new File(file));
            }
        }
        try {
            fileManager.setLocation(StandardLocation.CLASS_PATH, cpFiles);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.javaFileManager = new ForwardingJavaFileManager<JavaFileManager>((JavaFileManager)fileManager){

            @Override
            public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
                FelCompiler16.this.classLoader.add(qualifiedName, outputFile);
                return (JavaFileObject)outputFile;
            }
        };
        this.options = new ArrayList<String>();
    }

    @Override
    public Expression compile(JavaSource src) {
        Class<T> compile = this.compileToClass(src);
        try {
            return (Expression)compile.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized Class<T> compileToClass(JavaSource src) {
        ArrayList<FelJavaFileObject> compileSrcs = new ArrayList<FelJavaFileObject>();
        String className = src.getSimpleName();
        FelJavaFileObject compileSrc = new FelJavaFileObject(className, src.getSource());
        compileSrcs.add(compileSrc);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.javaFileManager, this.diagnostics, this.options, null, compileSrcs);
        Boolean result = task.call();
        if (result == null || !result.booleanValue()) {
            throw new CompileException(String.valueOf(src.getSource()) + "\n" + this.diagnostics.getDiagnostics().toString());
        }
        try {
            return this.loadClass(src.getName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class<T> loadClass(String qualifiedClassName) throws ClassNotFoundException {
        return this.classLoader.loadClass(qualifiedClassName);
    }

    static URI toUri(String name) {
        try {
            return new URI(name);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

