/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.CompileException;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.util.List;

public class Sub
extends StableFunction {
    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class<?> t = argMethod.returnType(ctx, node);
        sb.append("(");
        if (ReflectUtil.isPrimitiveOrWrapNumber(t)) {
            sb.append(argMethod.source(ctx, node));
        } else {
            CharSequence.class.isAssignableFrom(t);
        }
        sb.append(")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        List<FelNode> children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        Class<?> type = null;
        if (children.size() == 2) {
            FelNode left = children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            Class<?> leftType = lm.returnType(ctx, left);
            this.appendArg(sb, lm, ctx, left);
            FelNode right = children.get(1);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            sb.append("-");
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType)) throw new CompileException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[" + ReflectUtil.getClassName(leftType) + "\u3001" + ReflectUtil.getClassName(rightType) + "]\u3002\u51cf[-]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b");
            if (!ReflectUtil.isPrimitiveOrWrapNumber(rightType)) throw new CompileException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b[" + ReflectUtil.getClassName(leftType) + "\u3001" + ReflectUtil.getClassName(rightType) + "]\u3002\u51cf[-]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b");
            type = NumberUtil.arithmeticClass(leftType, rightType);
            return new FelMethod(type, sb.toString());
        } else {
            if (children.size() != 1) return new FelMethod(type, sb.toString());
            FelNode right = children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            sb.append("-");
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(rightType)) return new FelMethod(type, sb.toString());
            type = rightType;
        }
        return new FelMethod(type, sb.toString());
    }

    public String getName() {
        return "-";
    }

    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble(leftValue);
                double r = NumberUtil.toDouble(rightValue);
                return NumberUtil.parseNumber(l - r);
            }
            throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b");
        }
        if (children.size() == 1) {
            FelNode right = children.get(0);
            Object rightValue = right.eval(context);
            if (rightValue instanceof Number) {
                if (NumberUtil.isFloatingPoint(rightValue)) {
                    return NumberUtil.toDouble(rightValue) * -1.0;
                }
                return NumberUtil.parseNumber(((Number)rightValue).longValue() * -1L);
            }
            throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b");
        }
        throw new EvalException("\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u662f1\u62162");
    }

    public static void main(String[] args) {
        int a = -1;
        System.out.println(a);
    }
}

