/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda;

import java.util.Iterator;
import java.util.Map;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.agenda.operation.ActivateAsyncPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ActivatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ChangePlanItemInstanceToAvailableOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompleteCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CompletePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreatePlanItemInstanceForRepetitionOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.CreatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.DisablePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.DismissPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EnablePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.EvaluateCriteriaOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.ExitPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitPlanModelInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitStageInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.InitiatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.OccurPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.StartPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminateCaseInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TerminatePlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.agenda.operation.TriggerPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.criteria.PlanItemLifeCycleEvent;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.agenda.AbstractAgenda;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmmnEngineAgenda
extends AbstractAgenda
implements CmmnEngineAgenda {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCmmnEngineAgenda.class);

    public DefaultCmmnEngineAgenda(CommandContext commandContext) {
        super(commandContext);
    }

    public void addOperation(CmmnOperation operation, String caseInstanceId) {
        int operationIndex = this.getOperationIndex(operation);
        if (operationIndex >= 0) {
            this.operations.add(operationIndex, operation);
        } else {
            this.operations.addLast(operation);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Planned {}", (Object)operation);
        }
        if (caseInstanceId != null) {
            CommandContextUtil.addInvolvedCaseInstanceId(this.commandContext, caseInstanceId);
        }
    }

    protected int getOperationIndex(CmmnOperation operation) {
        if (!this.operations.isEmpty() && !(operation instanceof EvaluateCriteriaOperation)) {
            for (int i = 0; i < this.operations.size(); ++i) {
                if (!(this.operations.get(i) instanceof EvaluateCriteriaOperation)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void planInitPlanModelOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new InitPlanModelInstanceOperation(this.commandContext, caseInstanceEntity), caseInstanceEntity.getId());
    }

    @Override
    public void planInitStageOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new InitStageInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, null, false);
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId, boolean evaluateCaseInstanceCompleted) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, null, evaluateCaseInstanceCompleted);
    }

    @Override
    public void planEvaluateCriteriaOperation(String caseInstanceEntityId, PlanItemLifeCycleEvent lifeCycleEvent) {
        this.internalPlanEvaluateCriteria(caseInstanceEntityId, lifeCycleEvent, false);
    }

    protected void internalPlanEvaluateCriteria(String caseInstanceEntityId, PlanItemLifeCycleEvent planItemLifeCycleEvent, boolean evaluateCaseInstanceCompleted) {
        Iterator plannedOperations = this.operations.iterator();
        boolean found = false;
        while (!found && plannedOperations.hasNext()) {
            EvaluateCriteriaOperation evaluateCriteriaOperation;
            Runnable operation = (Runnable)plannedOperations.next();
            if (!(operation instanceof EvaluateCriteriaOperation) || (evaluateCriteriaOperation = (EvaluateCriteriaOperation)operation).getCaseInstanceEntityId() == null || evaluateCriteriaOperation.getPlanItemLifeCycleEvent() == null || evaluateCriteriaOperation.getPlanItemLifeCycleEvent().getTransition() == null || evaluateCriteriaOperation.getPlanItemLifeCycleEvent().getPlanItem() == null || planItemLifeCycleEvent == null || !evaluateCriteriaOperation.getCaseInstanceEntityId().equals(caseInstanceEntityId) || !evaluateCriteriaOperation.getPlanItemLifeCycleEvent().getTransition().equals(planItemLifeCycleEvent.getTransition()) || !evaluateCriteriaOperation.getPlanItemLifeCycleEvent().getPlanItem().getId().equals(planItemLifeCycleEvent.getPlanItem().getId()) || evaluateCriteriaOperation.isEvaluateCaseInstanceCompleted() != evaluateCaseInstanceCompleted) continue;
            LOGGER.debug("Deferred criteria evaluation for case instance with id '{}' to later in the execution. Plan item = {}, Plan item definition = {}, transition = {}", new Object[]{caseInstanceEntityId, planItemLifeCycleEvent.getPlanItem().getId(), planItemLifeCycleEvent.getPlanItem().getPlanItemDefinition(), planItemLifeCycleEvent.getTransition()});
            plannedOperations.remove();
            found = true;
        }
        EvaluateCriteriaOperation evaluateCriteriaOperation = new EvaluateCriteriaOperation(this.commandContext, caseInstanceEntityId, planItemLifeCycleEvent);
        evaluateCriteriaOperation.setEvaluateCaseInstanceCompleted(evaluateCaseInstanceCompleted);
        this.addOperation(evaluateCriteriaOperation, caseInstanceEntityId);
    }

    @Override
    public void planCreatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planCreatePlanItemInstanceForRepetitionOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CreatePlanItemInstanceForRepetitionOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planInitiatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new InitiatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planDismissPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new DismissPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planActivatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new ActivatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planStartPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new StartPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planStartPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId, Map<String, Object> variables) {
        this.addOperation(new StartPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId, variables), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planEnablePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new EnablePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planActivateAsyncPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String entryCriterionId) {
        this.addOperation(new ActivateAsyncPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, entryCriterionId), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planDisablePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new DisablePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planCompletePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new CompletePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planOccurPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new OccurPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planExitPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity, String exitCriterionId) {
        this.addOperation(new ExitPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity, exitCriterionId), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planTerminatePlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new TerminatePlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planChangePlanItemInstanceToAvailableOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new ChangePlanItemInstanceToAvailableOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planTriggerPlanItemInstanceOperation(PlanItemInstanceEntity planItemInstanceEntity) {
        this.addOperation(new TriggerPlanItemInstanceOperation(this.commandContext, planItemInstanceEntity), planItemInstanceEntity.getCaseInstanceId());
    }

    @Override
    public void planCompleteCaseInstanceOperation(CaseInstanceEntity caseInstanceEntity) {
        this.addOperation(new CompleteCaseInstanceOperation(this.commandContext, caseInstanceEntity), caseInstanceEntity.getId());
    }

    @Override
    public void planManualTerminateCaseInstanceOperation(String caseInstanceEntityId) {
        this.addOperation(new TerminateCaseInstanceOperation(this.commandContext, caseInstanceEntityId, true, null), caseInstanceEntityId);
    }

    @Override
    public void planTerminateCaseInstanceOperation(String caseInstanceEntityId, String exitCriterionId) {
        this.addOperation(new TerminateCaseInstanceOperation(this.commandContext, caseInstanceEntityId, false, exitCriterionId), caseInstanceEntityId);
    }
}

