/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChildTaskActivityBehavior
extends CoreCmmnTriggerableActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildTaskActivityBehavior.class);
    protected boolean isBlocking;
    protected String isBlockingExpression;
    protected List<IOParameter> inParameters;
    protected List<IOParameter> outParameters;

    public ChildTaskActivityBehavior(boolean isBlocking, String isBlockingExpression) {
        this.isBlocking = isBlocking;
        this.isBlockingExpression = isBlockingExpression;
    }

    public ChildTaskActivityBehavior(boolean isBlocking, String isBlockingExpression, List<IOParameter> inParameters, List<IOParameter> outParameters) {
        this(isBlocking, isBlockingExpression);
        this.inParameters = inParameters;
        this.outParameters = outParameters;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        this.execute(commandContext, planItemInstanceEntity, null);
    }

    public abstract void execute(CommandContext var1, PlanItemInstanceEntity var2, Map<String, Object> var3);

    protected boolean evaluateIsBlocking(DelegatePlanItemInstance planItemInstance) {
        boolean blocking = this.isBlocking;
        if (StringUtils.isNotEmpty((CharSequence)this.isBlockingExpression)) {
            Expression expression = CommandContextUtil.getExpressionManager().createExpression(this.isBlockingExpression);
            blocking = (Boolean)expression.getValue((VariableContainer)planItemInstance);
        }
        return blocking;
    }

    @Override
    public void trigger(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (!"active".equals(planItemInstance.getState())) {
            throw new FlowableException("Can only trigger a plan item that is in the ACTIVE state");
        }
        CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstance);
    }

    protected void handleInParameters(PlanItemInstanceEntity planItemInstanceEntity, CmmnEngineConfiguration cmmnEngineConfiguration, Map<String, Object> inParametersMap, ExpressionManager expressionManager) {
        if (this.inParameters == null) {
            return;
        }
        for (IOParameter inParameter : this.inParameters) {
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getTargetExpression())) {
                Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(inParameter.getTargetExpression());
                Object variableNameValue = expression.getValue((VariableContainer)planItemInstanceEntity);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("In parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)inParameter.getTargetExpression());
                }
            } else if (StringUtils.isNotEmpty((CharSequence)inParameter.getTarget())) {
                variableName = inParameter.getTarget();
            }
            Object variableValue = null;
            if (StringUtils.isNotEmpty((CharSequence)inParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(inParameter.getSourceExpression());
                variableValue = expression.getValue((VariableContainer)planItemInstanceEntity);
            } else if (StringUtils.isNotEmpty((CharSequence)inParameter.getSource())) {
                variableValue = planItemInstanceEntity.getVariable(inParameter.getSource());
            }
            if (variableName == null) continue;
            inParametersMap.put(variableName, variableValue);
        }
    }

    public abstract void deleteChildEntity(CommandContext var1, DelegatePlanItemInstance var2, boolean var3);
}

