/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.SignalEventListener;

public class StateTransition {
    public static Map<String, Set<String>> PLAN_ITEM_TRANSITIONS = new HashMap<String, Set<String>>();
    public static Map<String, Set<String>> EVENT_LISTENER_TRANSITIONS;

    protected static void addPlanItemTransition(String state, String ... transitions) {
        PLAN_ITEM_TRANSITIONS.put(state, new HashSet(transitions.length));
        for (String transition : transitions) {
            PLAN_ITEM_TRANSITIONS.get(state).add(transition);
        }
    }

    protected static void addEventListenerTransition(String state, String ... transitions) {
        EVENT_LISTENER_TRANSITIONS.put(state, new HashSet(transitions.length));
        for (String transition : transitions) {
            EVENT_LISTENER_TRANSITIONS.get(state).add(transition);
        }
    }

    public static boolean isPossible(PlanItemInstance planItemInstance, String transition) {
        PlanItemDefinition planItemDefinition = ((PlanItemInstanceEntity)planItemInstance).getPlanItem().getPlanItemDefinition();
        if (planItemDefinition instanceof EventListener && !(planItemDefinition instanceof SignalEventListener)) {
            return StateTransition.isEventListenerTransitionPossible(planItemInstance.getState(), transition);
        }
        return StateTransition.isPlanItemTransitionPossible(planItemInstance.getState(), transition);
    }

    protected static boolean isPlanItemTransitionPossible(String currentState, String transition) {
        return PLAN_ITEM_TRANSITIONS.get(currentState).contains(transition);
    }

    protected static boolean isEventListenerTransitionPossible(String currentState, String transition) {
        return EVENT_LISTENER_TRANSITIONS.get(currentState).contains(transition);
    }

    static {
        StateTransition.addPlanItemTransition(null, "create");
        StateTransition.addPlanItemTransition("wait_repetition", "create");
        StateTransition.addPlanItemTransition("available", "start", "enable", "parentSuspend", "exit");
        StateTransition.addPlanItemTransition("enabled", "disable", "manualStart", "parentSuspend", "exit");
        StateTransition.addPlanItemTransition("disabled", "reenable", "parentSuspend", "exit");
        StateTransition.addPlanItemTransition("active", "fault", "complete", "suspend", "terminate", "parentSuspend", "exit");
        StateTransition.addPlanItemTransition("async-active", "async-activate");
        StateTransition.addPlanItemTransition("failed", "reactivate", "exit");
        StateTransition.addPlanItemTransition("suspended", "resume", "parentResume", "exit");
        StateTransition.addPlanItemTransition("completed", new String[0]);
        StateTransition.addPlanItemTransition("terminated", new String[0]);
        EVENT_LISTENER_TRANSITIONS = new HashMap<String, Set<String>>();
        StateTransition.addEventListenerTransition(null, "create");
        StateTransition.addEventListenerTransition("unavailable", "initiate", "terminate", "exit", "suspend");
        StateTransition.addEventListenerTransition("available", "dismiss", "terminate", "occur", "exit", "suspend");
        StateTransition.addEventListenerTransition("suspended", "resume", "exit", "terminate");
        StateTransition.addEventListenerTransition("completed", new String[0]);
        StateTransition.addEventListenerTransition("terminated", new String[0]);
    }
}

