/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.EscalationEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.FormAwareConverter;
import org.flowable.editor.language.json.converter.FormKeyAwareConverter;
import org.flowable.editor.language.json.model.ModelInfo;

public class StartEventJsonConverter
extends BaseBpmnJsonConverter
implements FormAwareConverter,
FormKeyAwareConverter {
    protected Map<String, String> formMap;
    protected Map<String, ModelInfo> formKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        StartEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        StartEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("StartNoneEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartTimerEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartConditionalEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartErrorEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartEscalationEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartMessageEvent", StartEventJsonConverter.class);
        convertersToBpmnMap.put("StartSignalEvent", StartEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(StartEvent.class, StartEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        Event event = (Event)baseElement;
        if (event.getEventDefinitions().size() > 0) {
            EventDefinition eventDefinition = (EventDefinition)event.getEventDefinitions().get(0);
            if (eventDefinition instanceof TimerEventDefinition) {
                return "StartTimerEvent";
            }
            if (eventDefinition instanceof ConditionalEventDefinition) {
                return "StartConditionalEvent";
            }
            if (eventDefinition instanceof ErrorEventDefinition) {
                return "StartErrorEvent";
            }
            if (eventDefinition instanceof EscalationEventDefinition) {
                return "StartEscalationEvent";
            }
            if (eventDefinition instanceof MessageEventDefinition) {
                return "StartMessageEvent";
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                return "StartSignalEvent";
            }
        }
        return "StartNoneEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        StartEvent startEvent = (StartEvent)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getInitiator())) {
            propertiesNode.put("initiator", startEvent.getInitiator());
        }
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            if (this.formKeyMap != null && this.formKeyMap.containsKey(startEvent.getFormKey())) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                ModelInfo modelInfo = this.formKeyMap.get(startEvent.getFormKey());
                formRefNode.put("id", modelInfo.getId());
                formRefNode.put("name", modelInfo.getName());
                formRefNode.put("key", modelInfo.getKey());
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", startEvent.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("formfieldvalidation", startEvent.getValidateFormFields(), propertiesNode);
        if (startEvent.getSubProcess() instanceof EventSubProcess && !startEvent.isInterrupting()) {
            propertiesNode.put("interrupting", false);
        } else {
            propertiesNode.put("interrupting", true);
        }
        this.addFormProperties(startEvent.getFormProperties(), propertiesNode);
        this.addEventProperties((Event)startEvent, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        StartEvent startEvent = new StartEvent();
        startEvent.setInitiator(this.getPropertyValueAsString("initiator", elementNode));
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("StartNoneEvent".equals(stencilId)) {
            String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)formKey)) {
                startEvent.setFormKey(formKey);
            } else {
                JsonNode formReferenceNode = this.getProperty("formreference", elementNode);
                if (formReferenceNode != null && formReferenceNode.get("id") != null && this.formMap != null && this.formMap.containsKey(formReferenceNode.get("id").asText())) {
                    startEvent.setFormKey(this.formMap.get(formReferenceNode.get("id").asText()));
                }
            }
            String validateFormFields = this.getPropertyValueAsString("formfieldvalidation", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)validateFormFields)) {
                startEvent.setValidateFormFields(validateFormFields);
            }
            this.convertJsonToFormProperties(elementNode, (BaseElement)startEvent);
        } else if ("StartTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)startEvent);
        } else if ("StartConditionalEvent".equals(stencilId)) {
            this.convertJsonToConditionalDefinition(elementNode, (Event)startEvent);
        } else if ("StartErrorEvent".equals(stencilId)) {
            this.convertJsonToErrorDefinition(elementNode, (Event)startEvent);
        } else if ("StartEscalationEvent".equals(stencilId)) {
            this.convertJsonToEscalationDefinition(elementNode, (Event)startEvent);
        } else if ("StartMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)startEvent);
        } else if ("StartSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)startEvent);
        }
        if (!this.getPropertyValueAsBoolean("interrupting", elementNode)) {
            startEvent.setInterrupting(false);
        }
        return startEvent;
    }

    protected void addExtensionElement(String name, String elementText, Event event) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://flowable.org/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(elementText);
        event.addExtensionElement(extensionElement);
    }

    @Override
    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    @Override
    public void setFormKeyMap(Map<String, ModelInfo> formKeyMap) {
        this.formKeyMap = formKeyMap;
    }
}

