/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.lang.reflect.AnnotatedElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.util.GuardedAnnotationAccess;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class ClassLoaderSupport {
    private final ConcurrentMap<ClassLoader, ConcurrentHashMap<String, Package>> registeredPackages = new ConcurrentHashMap<ClassLoader, ConcurrentHashMap<String, Package>>();

    private static ClassLoaderSupport singleton() {
        return (ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class);
    }

    ClassLoaderSupport() {
    }

    public static void registerPackage(ClassLoader classLoader, String packageName, Package packageValue) {
        assert (classLoader != null);
        assert (packageName != null);
        assert (packageValue != null);
        GuardedAnnotationAccess.getAnnotations((AnnotatedElement)packageValue);
        ConcurrentMap classPackages = ClassLoaderSupport.singleton().registeredPackages.computeIfAbsent(classLoader, k -> new ConcurrentHashMap());
        classPackages.putIfAbsent(packageName, packageValue);
    }

    public static ConcurrentHashMap<String, Package> getRegisteredPackages(ClassLoader classLoader) {
        return (ConcurrentHashMap)ClassLoaderSupport.singleton().registeredPackages.get(classLoader);
    }
}

