/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.nodes;

import jdk.vm.ci.meta.ConstantReflectionProvider;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.ArrayLengthProvider;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.LimitedValueProxy;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class DeoptProxyNode
extends FloatingNode
implements LimitedValueProxy,
Node.ValueNumberable,
LIRLowerable,
Canonicalizable,
IterableNodeType,
ArrayLengthProvider {
    public static final NodeClass<DeoptProxyNode> TYPE = NodeClass.create(DeoptProxyNode.class);
    @Node.Input(value=InputType.Anchor)
    protected ValueNode proxyPoint;
    @Node.Input
    protected ValueNode value;
    protected final int deoptIndex;

    protected DeoptProxyNode(ValueNode value, ValueNode proxyPoint, int deoptIndex) {
        super(TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.proxyPoint = proxyPoint;
        this.deoptIndex = deoptIndex;
    }

    public static ValueNode create(ValueNode value, ValueNode proxyPoint, int deoptIndex) {
        ValueNode synonym = DeoptProxyNode.findSynonym(value);
        if (synonym != null) {
            return synonym;
        }
        return new DeoptProxyNode(value, proxyPoint, deoptIndex);
    }

    public boolean inferStamp() {
        return this.updateStamp(this.value.stamp(NodeView.DEFAULT));
    }

    public ValueNode getOriginalNode() {
        return this.value;
    }

    public void generate(NodeLIRBuilderTool gen) {
        gen.setResult((ValueNode)this, gen.operand((Node)this.value));
    }

    public Node canonical(CanonicalizerTool tool) {
        ValueNode synonym = DeoptProxyNode.findSynonym(this.value);
        return synonym != null ? synonym : this;
    }

    private static ValueNode findSynonym(ValueNode value) {
        return value.isConstant() ? value : null;
    }

    public boolean hasProxyPoint() {
        return this.proxyPoint != null;
    }

    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        ValueNode length = GraphUtil.arrayLength((ValueNode)this.value, (ArrayLengthProvider.FindLengthMode)mode, (ConstantReflectionProvider)constantReflection);
        return length != null && length.isConstant() ? length : null;
    }
}

