/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.jni.access.JNIAccessibleField;
import com.oracle.svm.jni.access.JNIAccessibleMethod;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import java.util.Collections;
import java.util.function.Function;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JNIAccessibleClass {
    private final Class<?> classObject;
    private EconomicMap<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> methods;
    private EconomicMap<String, JNIAccessibleField> fields;

    JNIAccessibleClass(Class<?> clazz) {
        this.classObject = clazz;
    }

    public Class<?> getClassObject() {
        return this.classObject;
    }

    public Iterable<JNIAccessibleField> getFields() {
        return this.fields != null ? this.fields.getValues() : Collections::emptyIterator;
    }

    MapCursor<String, JNIAccessibleField> getFieldsByName() {
        return this.fields != null ? this.fields.getEntries() : EconomicMap.emptyCursor();
    }

    public JNIAccessibleField getField(String name) {
        return this.fields != null ? (JNIAccessibleField)this.fields.get((Object)name) : null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addFieldIfAbsent(String name, Function<String, JNIAccessibleField> mappingFunction) {
        if (this.fields == null) {
            this.fields = ImageHeapMap.create();
        }
        if (!this.fields.containsKey((Object)name)) {
            this.fields.put((Object)name, (Object)mappingFunction.apply(name));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    void addMethodIfAbsent(JNIAccessibleMethodDescriptor descriptor, Function<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> mappingFunction) {
        if (this.methods == null) {
            this.methods = ImageHeapMap.create();
        }
        if (!this.methods.containsKey((Object)descriptor)) {
            this.methods.put((Object)descriptor, (Object)mappingFunction.apply(descriptor));
        }
    }

    public Iterable<JNIAccessibleMethod> getMethods() {
        return this.methods != null ? this.methods.getValues() : Collections::emptyIterator;
    }

    public MapCursor<JNIAccessibleMethodDescriptor, JNIAccessibleMethod> getMethodsByDescriptor() {
        return this.methods != null ? this.methods.getEntries() : EconomicMap.emptyCursor();
    }

    public JNIAccessibleMethod getMethod(JNIAccessibleMethodDescriptor descriptor) {
        return this.methods != null ? (JNIAccessibleMethod)this.methods.get((Object)descriptor) : null;
    }

    String getInternalName() {
        return MetaUtil.toInternalName((String)this.classObject.getName());
    }
}

