/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.reflect.hosted.MethodMetadata;
import com.oracle.svm.reflect.target.MethodMetadataDecoderImpl;
import com.oracle.svm.reflect.target.MethodMetadataEncoding;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.invoke.util.Wrapper;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotation;
import sun.reflect.annotation.TypeAnnotationParser;

public class MethodMetadataEncoderImpl
implements NativeImageCodeCache.MethodMetadataEncoder {
    private final CodeInfoEncoder.Encoders encoders;
    private final TreeSet<HostedType> sortedTypes;
    private Map<HostedType, Set<MethodMetadata.ReflectionMethodMetadata>> queriedMethodData;
    private Map<HostedType, Set<MethodMetadata>> reachableMethodData;
    private Map<HostedType, Set<MethodMetadata>> hidingMethodData;
    private byte[] methodDataEncoding;
    private byte[] methodDataIndexEncoding;
    private static final Method parseAllTypeAnnotations = ReflectionUtil.lookupMethod(TypeAnnotationParser.class, (String)"parseAllTypeAnnotations", (Class[])new Class[]{AnnotatedElement.class});
    private static final Method hasRealParameterData = ReflectionUtil.lookupMethod(Executable.class, (String)"hasRealParameterData", (Class[])new Class[0]);
    private static final Method getMethodSignature = ReflectionUtil.lookupMethod(Method.class, (String)"getGenericSignature", (Class[])new Class[0]);
    private static final Method getConstructorSignature = ReflectionUtil.lookupMethod(Constructor.class, (String)"getSignature", (Class[])new Class[0]);
    private static final byte CLASS_TYPE_PARAMETER = 0;
    private static final byte METHOD_TYPE_PARAMETER = 1;
    private static final byte CLASS_EXTENDS = 16;
    private static final byte CLASS_TYPE_PARAMETER_BOUND = 17;
    private static final byte METHOD_TYPE_PARAMETER_BOUND = 18;
    private static final byte FIELD = 19;
    private static final byte METHOD_RETURN = 20;
    private static final byte METHOD_RECEIVER = 21;
    private static final byte METHOD_FORMAL_PARAMETER = 22;
    private static final byte THROWS = 23;
    private static final Field locationInfoDepth = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"depth");
    private static final Field locationInfoLocations = ReflectionUtil.lookupField(TypeAnnotation.LocationInfo.class, (String)"locations");

    public MethodMetadataEncoderImpl(CodeInfoEncoder.Encoders encoders) {
        this.encoders = encoders;
        this.sortedTypes = new TreeSet<HostedType>(Comparator.comparingLong(t -> t.getHub().getTypeID()));
        if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
            this.queriedMethodData = new HashMap<HostedType, Set<MethodMetadata.ReflectionMethodMetadata>>();
            this.hidingMethodData = new HashMap<HostedType, Set<MethodMetadata>>();
        }
        if (SubstrateOptions.IncludeMethodData.getValue().booleanValue()) {
            this.reachableMethodData = new HashMap<HostedType, Set<MethodMetadata>>();
        }
    }

    @Override
    public void addReflectionMethodMetadata(MetaAccessProvider metaAccess, HostedMethod hostedMethod, Executable reflectMethod) {
        boolean reflectParameterDataPresent;
        TypeAnnotation[] typeAnnotations;
        HostedType declaringType = hostedMethod.getDeclaringClass();
        String name = hostedMethod.isConstructor() ? "<init>" : hostedMethod.getName();
        HostedType[] parameterTypes = MethodMetadataEncoderImpl.getParameterTypes(hostedMethod);
        int modifiers = reflectMethod.getModifiers();
        HostedType returnType = (HostedType)hostedMethod.getSignature().getReturnType(null);
        HostedType[] exceptionTypes = MethodMetadataEncoderImpl.getExceptionTypes(metaAccess, reflectMethod);
        String signature = MethodMetadataEncoderImpl.getSignature(reflectMethod);
        Annotation[] annotations = GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)((Object)hostedMethod));
        Annotation[][] parameterAnnotations = reflectMethod.getParameterAnnotations();
        try {
            typeAnnotations = (TypeAnnotation[])parseAllTypeAnnotations.invoke(null, reflectMethod);
            reflectParameterDataPresent = (Boolean)hasRealParameterData.invoke((Object)reflectMethod, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere();
        }
        MethodMetadataDecoderImpl.ReflectParameterDescriptor[] reflectParameterDescriptors = reflectParameterDataPresent ? MethodMetadataEncoderImpl.getReflectParameters(reflectMethod) : new MethodMetadataDecoderImpl.ReflectParameterDescriptor[]{};
        this.encoders.sourceMethodNames.addObject((Object)name);
        for (HostedType hostedType : parameterTypes) {
            this.encoders.sourceClasses.addObject(hostedType.getJavaClass());
        }
        this.encoders.sourceClasses.addObject(returnType.getJavaClass());
        for (HostedType hostedType : exceptionTypes) {
            this.encoders.sourceClasses.addObject(hostedType.getJavaClass());
        }
        this.encoders.sourceMethodNames.addObject((Object)signature);
        this.registerAnnotationValues(annotations);
        for (HostedType hostedType : parameterAnnotations) {
            this.registerAnnotationValues((Annotation[])hostedType);
        }
        for (TypeAnnotation typeAnnotation : typeAnnotations) {
            this.registerAnnotationValues(typeAnnotation.getAnnotation());
        }
        for (MethodMetadataDecoderImpl.ReflectParameterDescriptor reflectParameterDescriptor : reflectParameterDescriptors) {
            this.encoders.sourceMethodNames.addObject((Object)reflectParameterDescriptor.getName());
        }
        this.sortedTypes.add(declaringType);
        this.queriedMethodData.computeIfAbsent(declaringType, t -> new HashSet()).add(new MethodMetadata.ReflectionMethodMetadata(declaringType, name, parameterTypes, modifiers, returnType, exceptionTypes, signature, annotations, parameterAnnotations, typeAnnotations, reflectParameterDataPresent, reflectParameterDescriptors));
    }

    private void registerAnnotationValues(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            this.encoders.sourceClasses.addObject(annotation.annotationType());
            this.registerAnnotationValue(annotation.annotationType(), annotation);
        }
    }

    private void registerAnnotationValue(Class<?> type, Object value) {
        if (type.isAnnotation()) {
            Annotation annotation = (Annotation)value;
            AnnotationType annotationType = AnnotationType.getInstance(type);
            this.encoders.sourceClasses.addObject(type);
            for (Map.Entry<String, Class<?>> entry : annotationType.memberTypes().entrySet()) {
                Object annotationValue;
                String valueName = entry.getKey();
                Class<?> valueType = entry.getValue();
                this.encoders.sourceMethodNames.addObject((Object)valueName);
                Method getAnnotationValue = annotationType.members().get(valueName);
                getAnnotationValue.setAccessible(true);
                try {
                    annotationValue = getAnnotationValue.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw GraalError.shouldNotReachHere();
                }
                this.registerAnnotationValue(valueType, annotationValue);
            }
        } else if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (!componentType.isPrimitive()) {
                for (Object val : (Object[])value) {
                    this.registerAnnotationValue(componentType, val);
                }
            }
        } else if (type == Class.class) {
            this.encoders.sourceClasses.addObject((Object)((Class)value));
        } else if (type == String.class) {
            this.encoders.sourceMethodNames.addObject((Object)((String)value));
        } else if (type.isEnum()) {
            this.encoders.sourceClasses.addObject(type);
            this.encoders.sourceMethodNames.addObject((Object)((Enum)value).name());
        }
    }

    @Override
    public void addHidingMethodMetadata(HostedType declaringType, String name, HostedType[] parameterTypes) {
        this.encoders.sourceMethodNames.addObject((Object)name);
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        this.sortedTypes.add(declaringType);
        this.hidingMethodData.computeIfAbsent(declaringType, t -> new HashSet()).add(new MethodMetadata(declaringType, name, parameterTypes));
    }

    @Override
    public void addReachableMethodMetadata(HostedMethod method) {
        HostedType declaringType = method.getDeclaringClass();
        String name = method.getName();
        HostedType[] parameterTypes = MethodMetadataEncoderImpl.getParameterTypes(method);
        this.encoders.sourceMethodNames.addObject((Object)method.getName());
        for (HostedType parameterType : parameterTypes) {
            this.encoders.sourceClasses.addObject(parameterType.getJavaClass());
        }
        this.sortedTypes.add(declaringType);
        this.reachableMethodData.computeIfAbsent(declaringType, t -> {
            this.encoders.sourceClasses.addObject(declaringType.getJavaClass());
            return new HashSet();
        }).add(new MethodMetadata(declaringType, name, parameterTypes));
    }

    private static HostedType[] getParameterTypes(HostedMethod method) {
        HostedType[] parameterTypes = new HostedType[method.getSignature().getParameterCount(false)];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = (HostedType)method.getSignature().getParameterType(i, null);
        }
        return parameterTypes;
    }

    private static HostedType[] getExceptionTypes(MetaAccessProvider metaAccess, Executable reflectMethod) {
        Class<?>[] exceptionClasses = reflectMethod.getExceptionTypes();
        HostedType[] exceptionTypes = new HostedType[exceptionClasses.length];
        for (int i = 0; i < exceptionClasses.length; ++i) {
            exceptionTypes[i] = (HostedType)metaAccess.lookupJavaType(exceptionClasses[i]);
        }
        return exceptionTypes;
    }

    private static MethodMetadataDecoderImpl.ReflectParameterDescriptor[] getReflectParameters(Executable reflectMethod) {
        Parameter[] reflectParameters = reflectMethod.getParameters();
        MethodMetadataDecoderImpl.ReflectParameterDescriptor[] reflectParameterDescriptors = new MethodMetadataDecoderImpl.ReflectParameterDescriptor[reflectParameters.length];
        for (int i = 0; i < reflectParameters.length; ++i) {
            reflectParameterDescriptors[i] = new MethodMetadataDecoderImpl.ReflectParameterDescriptor(reflectParameters[i].getName(), reflectParameters[i].getModifiers());
        }
        return reflectParameterDescriptors;
    }

    @Override
    public void encodeAllAndInstall() {
        this.encodeMethodMetadata();
        ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).setMethodsEncoding(this.methodDataEncoding);
        ((MethodMetadataEncoding)ImageSingletons.lookup(MethodMetadataEncoding.class)).setIndexEncoding(this.methodDataIndexEncoding);
    }

    private void encodeMethodMetadata() {
        UnsafeArrayTypeWriter dataEncodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        UnsafeArrayTypeWriter indexEncodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        long nextTypeId = 0L;
        for (HostedType declaringType : this.sortedTypes) {
            long typeID = declaringType.getHub().getTypeID();
            assert (typeID >= nextTypeId);
            while (nextTypeId < typeID) {
                indexEncodingBuffer.putS4(-1L);
                ++nextTypeId;
            }
            assert (nextTypeId == typeID);
            long index = dataEncodingBuffer.getBytesWritten();
            indexEncodingBuffer.putS4(index);
            ++nextTypeId;
            if (SubstrateOptions.ConfigureReflectionMetadata.getValue().booleanValue()) {
                Set<MethodMetadata.ReflectionMethodMetadata> queriedMethods = this.queriedMethodData.getOrDefault(declaringType, Collections.emptySet());
                MethodMetadataEncoderImpl.encodeArray(dataEncodingBuffer, queriedMethods.toArray(new MethodMetadata.ReflectionMethodMetadata[0]), method -> {
                    assert (method.declaringType.equals(declaringType));
                    this.encodeReflectionMethod(dataEncodingBuffer, (MethodMetadata.ReflectionMethodMetadata)method);
                });
                Set<MethodMetadata> hidingMethods = this.hidingMethodData.getOrDefault(declaringType, Collections.emptySet());
                MethodMetadataEncoderImpl.encodeArray(dataEncodingBuffer, hidingMethods.toArray(new MethodMetadata[0]), hidingMethod -> this.encodeSimpleMethod(dataEncodingBuffer, (MethodMetadata)hidingMethod));
            }
            if (!SubstrateOptions.IncludeMethodData.getValue().booleanValue()) continue;
            Set<MethodMetadata> reachableMethods = this.reachableMethodData.get(declaringType);
            if (reachableMethods != null) {
                this.encodeType(dataEncodingBuffer, declaringType);
                MethodMetadataEncoderImpl.encodeArray(dataEncodingBuffer, reachableMethods.toArray(new MethodMetadata[0]), reachableMethod -> this.encodeSimpleMethod(dataEncodingBuffer, (MethodMetadata)reachableMethod));
                continue;
            }
            dataEncodingBuffer.putSV(-1L);
        }
        while (nextTypeId <= (long)((DynamicHubSupport)ImageSingletons.lookup(DynamicHubSupport.class)).getMaxTypeId()) {
            indexEncodingBuffer.putS4(-1L);
            ++nextTypeId;
        }
        this.methodDataEncoding = new byte[TypeConversion.asS4((long)dataEncodingBuffer.getBytesWritten())];
        dataEncodingBuffer.toArray(this.methodDataEncoding);
        this.methodDataIndexEncoding = new byte[TypeConversion.asS4((long)indexEncodingBuffer.getBytesWritten())];
        indexEncodingBuffer.toArray(this.methodDataIndexEncoding);
    }

    private void encodeReflectionMethod(UnsafeArrayTypeWriter buf, MethodMetadata.ReflectionMethodMetadata method) {
        this.encodeSimpleMethod(buf, method);
        buf.putUV((long)method.modifiers);
        this.encodeType(buf, method.returnType);
        MethodMetadataEncoderImpl.encodeArray(buf, method.exceptionTypes, exceptionType -> this.encodeType(buf, (HostedType)exceptionType));
        this.encodeName(buf, method.signature);
        MethodMetadataEncoderImpl.encodeByteArray(buf, this.encodeAnnotations(method.annotations));
        MethodMetadataEncoderImpl.encodeByteArray(buf, this.encodeParameterAnnotations(method.parameterAnnotations));
        MethodMetadataEncoderImpl.encodeByteArray(buf, this.encodeTypeAnnotations(method.typeAnnotations));
        buf.putU1(method.hasRealParameterData ? 1L : 0L);
        if (method.hasRealParameterData) {
            MethodMetadataEncoderImpl.encodeArray(buf, method.reflectParameters, reflectParameter -> {
                this.encodeName(buf, reflectParameter.getName());
                buf.putS4((long)reflectParameter.getModifiers());
            });
        }
    }

    private void encodeSimpleMethod(UnsafeArrayTypeWriter buf, MethodMetadata method) {
        this.encodeName(buf, method.name);
        MethodMetadataEncoderImpl.encodeArray(buf, method.parameterTypes, parameterType -> this.encodeType(buf, (HostedType)parameterType));
    }

    private void encodeType(UnsafeArrayTypeWriter buf, HostedType type) {
        buf.putSV((long)this.encoders.sourceClasses.getIndex(type.getJavaClass()));
    }

    private void encodeName(UnsafeArrayTypeWriter buf, String name) {
        buf.putSV((long)this.encoders.sourceMethodNames.getIndex((Object)name));
    }

    private static <T> void encodeArray(UnsafeArrayTypeWriter buf, T[] array, Consumer<T> elementEncoder) {
        buf.putUV((long)array.length);
        for (T elem : array) {
            elementEncoder.accept(elem);
        }
    }

    private static void encodeByteArray(UnsafeArrayTypeWriter buf, byte[] array) {
        buf.putUV((long)array.length);
        for (byte b : array) {
            buf.putS1((long)b);
        }
    }

    private static String getSignature(Executable method) {
        try {
            return (String)(method instanceof Method ? getMethodSignature.invoke((Object)method, new Object[0]) : getConstructorSignature.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GraalError.shouldNotReachHere();
        }
    }

    public byte[] encodeAnnotations(Annotation[] annotations) {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        buf.putU2((long)annotations.length);
        for (Annotation annotation : annotations) {
            this.encodeAnnotation(buf, annotation);
        }
        return buf.toArray();
    }

    private byte[] encodeParameterAnnotations(Annotation[][] annotations) {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        buf.putU1((long)annotations.length);
        for (Annotation[] parameterAnnotations : annotations) {
            buf.putU2((long)parameterAnnotations.length);
            for (Annotation parameterAnnotation : parameterAnnotations) {
                this.encodeAnnotation(buf, parameterAnnotation);
            }
        }
        return buf.toArray();
    }

    private void encodeAnnotation(UnsafeArrayTypeWriter buf, Annotation annotation) {
        buf.putS4((long)this.encoders.sourceClasses.getIndex(annotation.annotationType()));
        AnnotationType type = AnnotationType.getInstance(annotation.annotationType());
        buf.putU2((long)type.members().size());
        for (Map.Entry<String, Method> entry : type.members().entrySet()) {
            String memberName = entry.getKey();
            Method valueAccessor = entry.getValue();
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)memberName));
            try {
                this.encodeValue(buf, valueAccessor.invoke((Object)annotation, new Object[0]), type.memberTypes().get(memberName));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    private void encodeValue(UnsafeArrayTypeWriter buf, Object value, Class<?> type) {
        buf.putU1((long)MethodMetadataEncoderImpl.tag(type));
        if (type.isAnnotation()) {
            this.encodeAnnotation(buf, (Annotation)value);
        } else if (type.isEnum()) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex(type));
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((Enum)value).name()));
        } else if (type.isArray()) {
            this.encodeArray(buf, value, type.getComponentType());
        } else if (type == Class.class) {
            buf.putS4((long)this.encoders.sourceClasses.getIndex((Object)((Class)value)));
        } else if (type == String.class) {
            buf.putS4((long)this.encoders.sourceMethodNames.getIndex((Object)((String)value)));
        } else if (type.isPrimitive() || Wrapper.isWrapperType(type)) {
            Wrapper wrapper = type.isPrimitive() ? Wrapper.forPrimitiveType(type) : Wrapper.forWrapperType(type);
            switch (wrapper) {
                case BOOLEAN: {
                    buf.putU1((Boolean)value != false ? 1L : 0L);
                    break;
                }
                case BYTE: {
                    buf.putS1((long)((Byte)value).byteValue());
                    break;
                }
                case SHORT: {
                    buf.putS2((long)((Short)value).shortValue());
                    break;
                }
                case CHAR: {
                    buf.putU2((long)((Character)value).charValue());
                    break;
                }
                case INT: {
                    buf.putS4((long)((Integer)value).intValue());
                    break;
                }
                case LONG: {
                    buf.putS8(((Long)value).longValue());
                    break;
                }
                case FLOAT: {
                    buf.putS4((long)Float.floatToRawIntBits(((Float)value).floatValue()));
                    break;
                }
                case DOUBLE: {
                    buf.putS8(Double.doubleToRawLongBits((Double)value));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        } else {
            throw GraalError.shouldNotReachHere();
        }
    }

    private void encodeArray(UnsafeArrayTypeWriter buf, Object value, Class<?> componentType) {
        block10: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            if (componentType.isPrimitive()) break block9;
                                            Object[] array = (Object[])value;
                                            buf.putU2((long)array.length);
                                            for (Object val : array) {
                                                this.encodeValue(buf, val, componentType);
                                            }
                                            break block10;
                                        }
                                        if (componentType != Boolean.TYPE) break block11;
                                        boolean[] array = (boolean[])value;
                                        buf.putU2((long)array.length);
                                        for (boolean val : array) {
                                            this.encodeValue(buf, val, componentType);
                                        }
                                        break block10;
                                    }
                                    if (componentType != Byte.TYPE) break block12;
                                    byte[] array = (byte[])value;
                                    buf.putU2((long)array.length);
                                    for (byte val : array) {
                                        this.encodeValue(buf, val, componentType);
                                    }
                                    break block10;
                                }
                                if (componentType != Short.TYPE) break block13;
                                short[] array = (short[])value;
                                buf.putU2((long)array.length);
                                for (short val : array) {
                                    this.encodeValue(buf, val, componentType);
                                }
                                break block10;
                            }
                            if (componentType != Character.TYPE) break block14;
                            char[] array = (char[])value;
                            buf.putU2((long)array.length);
                            for (char val : array) {
                                this.encodeValue(buf, Character.valueOf(val), componentType);
                            }
                            break block10;
                        }
                        if (componentType != Integer.TYPE) break block15;
                        int[] array = (int[])value;
                        buf.putU2((long)array.length);
                        for (int val : array) {
                            this.encodeValue(buf, val, componentType);
                        }
                        break block10;
                    }
                    if (componentType != Long.TYPE) break block16;
                    long[] array = (long[])value;
                    buf.putU2((long)array.length);
                    for (long val : array) {
                        this.encodeValue(buf, val, componentType);
                    }
                    break block10;
                }
                if (componentType != Float.TYPE) break block17;
                float[] array = (float[])value;
                buf.putU2((long)array.length);
                for (float val : array) {
                    this.encodeValue(buf, Float.valueOf(val), componentType);
                }
                break block10;
            }
            if (componentType != Double.TYPE) break block10;
            double[] array = (double[])value;
            buf.putU2((long)array.length);
            for (double val : array) {
                this.encodeValue(buf, val, componentType);
            }
        }
    }

    private static byte tag(Class<?> type) {
        if (type.isAnnotation()) {
            return 64;
        }
        if (type.isEnum()) {
            return 101;
        }
        if (type.isArray()) {
            return 91;
        }
        if (type == Class.class) {
            return 99;
        }
        if (type == String.class) {
            return 115;
        }
        if (type.isPrimitive()) {
            return (byte)Wrapper.forPrimitiveType(type).basicTypeChar();
        }
        if (Wrapper.isWrapperType(type)) {
            return (byte)Wrapper.forWrapperType(type).basicTypeChar();
        }
        throw GraalError.shouldNotReachHere();
    }

    private byte[] encodeTypeAnnotations(TypeAnnotation[] annotations) {
        UnsafeArrayTypeWriter buf = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        buf.putU2((long)annotations.length);
        for (TypeAnnotation typeAnnotation : annotations) {
            this.encodeTypeAnnotation(buf, typeAnnotation);
        }
        return buf.toArray();
    }

    private void encodeTypeAnnotation(UnsafeArrayTypeWriter buf, TypeAnnotation typeAnnotation) {
        MethodMetadataEncoderImpl.encodeTargetInfo(buf, typeAnnotation.getTargetInfo());
        MethodMetadataEncoderImpl.encodeLocationInfo(buf, typeAnnotation.getLocationInfo());
        this.encodeAnnotation(buf, typeAnnotation.getAnnotation());
    }

    private static void encodeTargetInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.TypeAnnotationTargetInfo targetInfo) {
        switch (targetInfo.getTarget()) {
            case CLASS_TYPE_PARAMETER: {
                buf.putU1(0L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                buf.putU1(1L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case CLASS_EXTENDS: {
                buf.putU1(16L);
                buf.putS2(-1L);
                break;
            }
            case CLASS_IMPLEMENTS: {
                buf.putU1(16L);
                buf.putS2((long)targetInfo.getCount());
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                buf.putU1(17L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                buf.putU1(18L);
                buf.putU1((long)targetInfo.getCount());
                buf.putU1((long)targetInfo.getSecondaryIndex());
                break;
            }
            case FIELD: {
                buf.putU1(19L);
                break;
            }
            case METHOD_RETURN: {
                buf.putU1(20L);
                break;
            }
            case METHOD_RECEIVER: {
                buf.putU1(21L);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                buf.putU1(22L);
                buf.putU1((long)targetInfo.getCount());
                break;
            }
            case THROWS: {
                buf.putU1(23L);
                buf.putU2((long)targetInfo.getCount());
            }
        }
    }

    private static void encodeLocationInfo(UnsafeArrayTypeWriter buf, TypeAnnotation.LocationInfo locationInfo) {
        try {
            TypeAnnotation.LocationInfo.Location[] locations;
            int depth = (Integer)locationInfoDepth.get(locationInfo);
            buf.putU1((long)depth);
            for (TypeAnnotation.LocationInfo.Location location : locations = (TypeAnnotation.LocationInfo.Location[])locationInfoLocations.get(locationInfo)) {
                buf.putS1((long)location.tag);
                buf.putU1((long)location.index);
            }
        }
        catch (IllegalAccessException e) {
            throw GraalError.shouldNotReachHere();
        }
    }

    static class Factory
    implements NativeImageCodeCache.MethodMetadataEncoderFactory {
        Factory() {
        }

        @Override
        public NativeImageCodeCache.MethodMetadataEncoder create(CodeInfoEncoder.Encoders encoders) {
            return new MethodMetadataEncoderImpl(encoders);
        }
    }
}

