/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.content;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.greenrobot.eclipse.core.internal.content.Activator;
import org.greenrobot.eclipse.core.internal.content.BasicDescription;
import org.greenrobot.eclipse.core.internal.content.ContentMessages;
import org.greenrobot.eclipse.core.internal.content.ContentType;
import org.greenrobot.eclipse.core.internal.content.ContentTypeBuilder;
import org.greenrobot.eclipse.core.internal.content.ContentTypeCatalog;
import org.greenrobot.eclipse.core.internal.content.ContentTypeHandler;
import org.greenrobot.eclipse.core.internal.content.ContentTypeMatcher;
import org.greenrobot.eclipse.core.internal.content.ILazySource;
import org.greenrobot.eclipse.core.internal.content.LazyInputStream;
import org.greenrobot.eclipse.core.internal.content.LazyReader;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IExtensionRegistry;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeEvent;
import org.greenrobot.eclipse.core.runtime.IRegistryChangeListener;
import org.greenrobot.eclipse.core.runtime.ISafeRunnable;
import org.greenrobot.eclipse.core.runtime.InvalidRegistryObjectException;
import org.greenrobot.eclipse.core.runtime.ListenerList;
import org.greenrobot.eclipse.core.runtime.SafeRunner;
import org.greenrobot.eclipse.core.runtime.Status;
import org.greenrobot.eclipse.core.runtime.content.IContentDescription;
import org.greenrobot.eclipse.core.runtime.content.IContentType;
import org.greenrobot.eclipse.core.runtime.content.IContentTypeManager;
import org.greenrobot.eclipse.core.runtime.content.IContentTypeMatcher;
import org.greenrobot.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.greenrobot.eclipse.core.runtime.preferences.IScopeContext;
import org.greenrobot.eclipse.core.runtime.preferences.InstanceScope;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.service.prefs.BackingStoreException;

public class ContentTypeManager
extends ContentTypeMatcher
implements IContentTypeManager {
    private static IRegistryChangeListener runtimeExtensionListener = new ContentTypeRegistryChangeListener();
    private static IRegistryChangeListener contentExtensionListener = new ContentTypeRegistryChangeListener();
    private static volatile ContentTypeManager instance;
    public static final int BLOCK_SIZE = 1024;
    public static final String CONTENT_TYPE_PREF_NODE = "org.eclipse.core.runtime/content-types";
    private static final String OPTION_DEBUG_CONTENT_TYPES = "org.eclipse.core.contenttype/debug";
    static final boolean DEBUGGING;
    private ContentTypeCatalog catalog;
    private int catalogGeneration;
    protected final ListenerList<IContentTypeManager.IContentTypeChangeListener> contentTypeListeners = new ListenerList();

    static {
        DEBUGGING = Activator.getDefault().getBooleanDebugOption(OPTION_DEBUG_CONTENT_TYPES, false);
    }

    public static void addRegistryChangeListener(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        registry.addRegistryChangeListener(runtimeExtensionListener, "org.greenrobot.eclipse.core.runtime");
        registry.addRegistryChangeListener(contentExtensionListener, "org.greenrobot.eclipse.core.contenttype");
    }

    public static void shutdown() {
        instance = null;
    }

    public static void removeRegistryChangeListener(IExtensionRegistry registry) {
        if (registry == null) {
            return;
        }
        ContentTypeManager.getInstance().invalidate();
        registry.removeRegistryChangeListener(runtimeExtensionListener);
        registry.removeRegistryChangeListener(contentExtensionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContentTypeManager getInstance() {
        if (instance != null) return instance;
        Class<ContentTypeManager> clazz = ContentTypeManager.class;
        synchronized (ContentTypeManager.class) {
            if (instance != null) return instance;
            instance = new ContentTypeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static String getFileExtension(String fileName) {
        int dotPosition = fileName.lastIndexOf(46);
        return dotPosition == -1 || dotPosition == fileName.length() - 1 ? "" : fileName.substring(dotPosition + 1);
    }

    protected static ILazySource readBuffer(InputStream contents) {
        return new LazyInputStream(contents, 1024);
    }

    protected static ILazySource readBuffer(Reader contents) {
        return new LazyReader(contents, 1024);
    }

    public ContentTypeManager() {
        super(null, InstanceScope.INSTANCE);
    }

    protected ContentTypeBuilder createBuilder(ContentTypeCatalog newCatalog) {
        return new ContentTypeBuilder(newCatalog);
    }

    @Override
    public IContentType[] getAllContentTypes() {
        ContentTypeCatalog currentCatalog = this.getCatalog();
        IContentType[] types = currentCatalog.getAllContentTypes();
        IContentType[] result = new IContentType[types.length];
        int generation = currentCatalog.getGeneration();
        int i = 0;
        while (i < result.length) {
            result[i] = new ContentTypeHandler((ContentType)types[i], generation);
            ++i;
        }
        return result;
    }

    protected synchronized ContentTypeCatalog getCatalog() {
        if (this.catalog != null) {
            return this.catalog;
        }
        ContentTypeCatalog newCatalog = new ContentTypeCatalog(this, this.catalogGeneration++);
        ContentTypeBuilder builder = this.createBuilder(newCatalog);
        try {
            builder.buildCatalog(this.getContext());
            this.catalog = newCatalog;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
        newCatalog.organize();
        return newCatalog;
    }

    @Override
    public IContentType getContentType(String contentTypeIdentifier) {
        ContentTypeCatalog currentCatalog = this.getCatalog();
        ContentType type = currentCatalog.getContentType(contentTypeIdentifier);
        return type == null ? null : new ContentTypeHandler(type, currentCatalog.getGeneration());
    }

    @Override
    public IContentTypeMatcher getMatcher(IContentTypeManager.ISelectionPolicy customPolicy, IScopeContext context) {
        return new ContentTypeMatcher(customPolicy, context == null ? this.getContext() : context);
    }

    IEclipsePreferences getPreferences() {
        return this.getPreferences(this.getContext());
    }

    IEclipsePreferences getPreferences(IScopeContext context) {
        return context.getNode(CONTENT_TYPE_PREF_NODE);
    }

    synchronized void invalidate() {
        if (DEBUGGING && this.catalog != null) {
            ContentMessages.message("Registry discarded");
        }
        this.catalog = null;
    }

    @Override
    public void addContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.add(listener);
    }

    @Override
    public void removeContentTypeChangeListener(IContentTypeManager.IContentTypeChangeListener listener) {
        this.contentTypeListeners.remove(listener);
    }

    public void fireContentTypeChangeEvent(IContentType type) {
        IContentType eventObject = type;
        eventObject = type instanceof ContentType ? new ContentTypeHandler((ContentType)type, ((ContentType)type).getCatalog().getGeneration()) : type;
        for (final IContentTypeManager.IContentTypeChangeListener listener : this.contentTypeListeners) {
            final IContentTypeManager.ContentTypeChangeEvent event = new IContentTypeManager.ContentTypeChangeEvent(eventObject);
            ISafeRunnable job = new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() throws Exception {
                    listener.contentTypeChanged(event);
                }
            };
            SafeRunner.run(job);
        }
    }

    @Override
    public IContentDescription getSpecificDescription(BasicDescription description) {
        return description;
    }

    @Override
    public final void removeContentType(String contentTypeIdentifier) throws CoreException {
        if (contentTypeIdentifier == null) {
            return;
        }
        IContentType contentType = this.getContentType(contentTypeIdentifier);
        if (contentType == null) {
            return;
        }
        if (!contentType.isUserDefined()) {
            throw new IllegalArgumentException("Can only delete content-types defined by users.");
        }
        this.getCatalog().removeContentType(contentType.getId());
        ArrayList<String> userDefinedIds = new ArrayList<String>(Arrays.asList(this.getUserDefinedContentTypeIds()));
        userDefinedIds.remove(contentType.getId());
        this.getContext().getNode("userDefined").put("userDefined", userDefinedIds.stream().collect(Collectors.joining(",")));
        try {
            this.getContext().getNode("userDefined").flush();
        }
        catch (BackingStoreException e) {
            String message = NLS.bind(ContentMessages.content_errorSavingSettings, contentType.getId());
            Status status = new Status(4, "org.greenrobot.eclipse.core.contenttype", 0, message, e);
            throw new CoreException(status);
        }
        this.getCatalog().organize();
        this.fireContentTypeChangeEvent(contentType);
    }

    @Override
    public final IContentType addContentType(String id, String name, IContentType baseType) throws CoreException {
        if (id == null) {
            throw new IllegalArgumentException("Content-type 'id' mustn't be null");
        }
        if (id.contains(",")) {
            throw new IllegalArgumentException("Content-Type id mustn't contain ','");
        }
        if (this.getContentType(id) != null) {
            throw new IllegalArgumentException("Content-type '" + id + "' already exists.");
        }
        ContentType contentType = ContentType.createContentType(this.getCatalog(), id, name, (byte)0, new String[]{}, new String[]{}, new String[]{}, baseType != null ? baseType.getId() : null, null, null, null);
        this.getCatalog().addContentType(contentType);
        String currentUserDefined = this.getContext().getNode("userDefined").get("userDefined", "");
        if (!currentUserDefined.isEmpty()) {
            currentUserDefined = String.valueOf(currentUserDefined) + ",";
        }
        this.getContext().getNode("userDefined").put("userDefined", String.valueOf(currentUserDefined) + id);
        contentType.setValidation((byte)0);
        IEclipsePreferences contextTypeNode = this.getContext().getNode(contentType.getId());
        contextTypeNode.put("name", name);
        if (baseType != null) {
            contextTypeNode.put("baseTypeId", baseType.getId());
        }
        try {
            this.getContext().getNode("userDefined").flush();
            contextTypeNode.flush();
        }
        catch (BackingStoreException e) {
            String message = NLS.bind(ContentMessages.content_errorSavingSettings, id);
            Status status = new Status(4, "org.greenrobot.eclipse.core.contenttype", 0, message, e);
            throw new CoreException(status);
        }
        this.getCatalog().organize();
        this.fireContentTypeChangeEvent(contentType);
        return contentType;
    }

    private String[] getUserDefinedContentTypeIds() {
        return ContentTypeManager.getUserDefinedContentTypeIds(this.getContext());
    }

    static String[] getUserDefinedContentTypeIds(IScopeContext context) {
        String ids = context.getNode("userDefined").get("userDefined", "");
        if (ids.isEmpty()) {
            return new String[0];
        }
        return ids.split(",");
    }

    private static class ContentTypeRegistryChangeListener
    implements IRegistryChangeListener {
        private ContentTypeRegistryChangeListener() {
        }

        @Override
        public void registryChanged(IRegistryChangeEvent event) {
            if (event.getExtensionDeltas("org.greenrobot.eclipse.core.runtime", "contentTypes").length == 0 && event.getExtensionDeltas("org.greenrobot.eclipse.core.contenttype", "contentTypes").length == 0) {
                return;
            }
            ContentTypeManager.getInstance().invalidate();
        }
    }
}

