/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.events;

import org.greenrobot.eclipse.core.resources.IResourceChangeListener;
import org.greenrobot.eclipse.core.resources.ISaveParticipant;
import org.greenrobot.eclipse.core.resources.IncrementalProjectBuilder;
import org.greenrobot.eclipse.core.resources.ResourcesPlugin;
import org.greenrobot.eclipse.core.runtime.PerformanceStats;

public class ResourceStats {
    private static PerformanceStats currentStats;
    public static final String EVENT_BUILDERS = "org.eclipse.core.resources/perf/builders";
    public static final String EVENT_LISTENERS = "org.eclipse.core.resources/perf/listeners";
    public static final String EVENT_SAVE_PARTICIPANTS = "org.eclipse.core.resources/perf/save.participants";
    public static final String EVENT_SNAPSHOT = "org.eclipse.core.resources/perf/snapshot";
    public static boolean TRACE_BUILDERS;
    public static boolean TRACE_LISTENERS;
    public static boolean TRACE_SAVE_PARTICIPANTS;
    public static boolean TRACE_SNAPSHOT;

    static {
        TRACE_BUILDERS = PerformanceStats.isEnabled(EVENT_BUILDERS);
        TRACE_LISTENERS = PerformanceStats.isEnabled(EVENT_LISTENERS);
        TRACE_SAVE_PARTICIPANTS = PerformanceStats.isEnabled(EVENT_SAVE_PARTICIPANTS);
        TRACE_SNAPSHOT = PerformanceStats.isEnabled(EVENT_SNAPSHOT);
    }

    public static void endBuild() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endNotify() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endSave() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void endSnapshot() {
        if (currentStats != null) {
            currentStats.endRun();
        }
        currentStats = null;
    }

    public static void listenerAdded(IResourceChangeListener listener) {
        if (listener != null) {
            PerformanceStats.getStats(EVENT_LISTENERS, listener.getClass().getName());
        }
    }

    public static void listenerRemoved(IResourceChangeListener listener) {
        if (listener != null) {
            PerformanceStats.removeStats(EVENT_LISTENERS, listener.getClass().getName());
        }
    }

    public static void startBuild(IncrementalProjectBuilder builder) {
        currentStats = PerformanceStats.getStats(EVENT_BUILDERS, builder);
        currentStats.startRun(builder.getProject().getName());
    }

    public static void startNotify(IResourceChangeListener listener) {
        currentStats = PerformanceStats.getStats(EVENT_LISTENERS, listener);
        currentStats.startRun();
    }

    public static void startSnapshot() {
        currentStats = PerformanceStats.getStats(EVENT_SNAPSHOT, ResourcesPlugin.getWorkspace());
        currentStats.startRun();
    }

    public static void startSave(ISaveParticipant participant) {
        currentStats = PerformanceStats.getStats(EVENT_SAVE_PARTICIPANTS, participant);
        currentStats.startRun();
    }
}

