/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.expressions;

import org.greenrobot.eclipse.core.expressions.EvaluationResult;
import org.greenrobot.eclipse.core.expressions.Expression;
import org.greenrobot.eclipse.core.expressions.ExpressionInfo;
import org.greenrobot.eclipse.core.expressions.IEvaluationContext;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;

public class NotExpression
extends Expression {
    private static final int HASH_INITIAL = NotExpression.class.getName().hashCode();
    private Expression fExpression;

    public NotExpression(Expression expression) {
        Assert.isNotNull(expression);
        this.fExpression = expression;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        return this.fExpression.evaluate(context).not();
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        this.fExpression.collectExpressionInfo(info);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NotExpression)) {
            return false;
        }
        NotExpression that = (NotExpression)object;
        return this.fExpression.equals(that.fExpression);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fExpression.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [expression=");
        builder.append(this.fExpression);
        builder.append("]");
        return builder.toString();
    }
}

