/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.localstore;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class SafeFileOutputStream
extends OutputStream {
    protected File temp;
    protected File target;
    protected OutputStream output;
    protected boolean failed = false;
    protected static final String EXTENSION = ".bak";

    public SafeFileOutputStream(File file) throws IOException {
        this(file.getAbsolutePath(), null);
    }

    public SafeFileOutputStream(String targetPath, String tempPath) throws IOException {
        this.target = new File(targetPath);
        this.createTempFile(tempPath);
        if (!this.target.exists()) {
            if (!this.temp.exists()) {
                this.output = new BufferedOutputStream(new FileOutputStream(this.target));
                return;
            }
            Files.copy(this.temp.toPath(), this.target.toPath(), new CopyOption[0]);
        }
        this.output = new BufferedOutputStream(new FileOutputStream(this.temp));
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.close();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
        if (this.failed) {
            this.temp.delete();
        } else {
            this.commit();
        }
    }

    protected void commit() throws IOException {
        if (!this.temp.exists()) {
            return;
        }
        Files.copy(this.temp.toPath(), this.target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        this.temp.delete();
    }

    protected void createTempFile(String tempPath) {
        if (tempPath == null) {
            tempPath = String.valueOf(this.target.getAbsolutePath()) + EXTENSION;
        }
        this.temp = new File(tempPath);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.output.flush();
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }

    public String getTempFilePath() {
        return this.temp.getAbsolutePath();
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.output.write(b);
        }
        catch (IOException e) {
            this.failed = true;
            throw e;
        }
    }
}

