/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources;

import org.greenrobot.eclipse.core.internal.utils.Policy;
import org.greenrobot.eclipse.core.resources.IFilterMatcherDescriptor;
import org.greenrobot.eclipse.core.resources.filtermatchers.AbstractFileInfoMatcher;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IConfigurationElement;

public class FilterDescriptor
implements IFilterMatcherDescriptor {
    private String id;
    private String name;
    private String description;
    private String argumentType;
    private boolean isFirst = false;
    private IConfigurationElement element;

    public FilterDescriptor(IConfigurationElement element) {
        this(element, true);
    }

    public FilterDescriptor(IConfigurationElement element, boolean instantiateFactory) {
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.description = element.getAttribute("description");
        this.argumentType = element.getAttribute("argumentType");
        if (this.argumentType == null) {
            this.argumentType = "none";
        }
        this.element = element;
        String ordering = element.getAttribute("ordering");
        if (ordering != null) {
            this.isFirst = ordering.equals("first");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getArgumentType() {
        return this.argumentType;
    }

    public AbstractFileInfoMatcher createFilter() {
        try {
            return (AbstractFileInfoMatcher)this.element.createExecutableExtension("class");
        }
        catch (CoreException e) {
            Policy.log(e);
            return null;
        }
    }

    @Override
    public boolean isFirstOrdering() {
        return this.isFirst;
    }
}

