/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.internal.resources;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.greenrobot.eclipse.core.internal.events.BuilderPersistentInfo;
import org.greenrobot.eclipse.core.internal.resources.ResourceException;
import org.greenrobot.eclipse.core.internal.resources.SavedState;
import org.greenrobot.eclipse.core.internal.resources.Workspace;
import org.greenrobot.eclipse.core.internal.resources.WorkspaceTreeReader_1;
import org.greenrobot.eclipse.core.internal.utils.Messages;
import org.greenrobot.eclipse.core.internal.utils.Policy;
import org.greenrobot.eclipse.core.internal.watson.ElementTree;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.Path;

public class WorkspaceTreeReader_2
extends WorkspaceTreeReader_1 {
    private List<BuilderPersistentInfo> builderInfos;

    public WorkspaceTreeReader_2(Workspace workspace) {
        super(workspace);
    }

    @Override
    protected int getVersion() {
        return 67305986;
    }

    @Override
    protected void readBuildersPersistentInfo(IProject project, DataInputStream input, List<BuilderPersistentInfo> builders, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            int builderCount = input.readInt();
            int i = 0;
            while (i < builderCount) {
                BuilderPersistentInfo info = this.readBuilderInfo(project, input, i);
                int n = input.readInt();
                IProject[] projects = new IProject[n];
                int j = 0;
                while (j < n) {
                    projects[j] = this.workspace.getRoot().getProject(input.readUTF());
                    ++j;
                }
                info.setInterestingProjects(projects);
                builders.add(info);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void readTree(DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = Messages.resources_reading;
                monitor.beginTask(message, 100);
                this.builderInfos = new ArrayList<BuilderPersistentInfo>(20);
                this.readWorkspaceFields(input, Policy.subMonitorFor(monitor, Policy.opWork * 20 / 100));
                HashMap<String, SavedState> savedStates = new HashMap<String, SavedState>(20);
                ArrayList<SavedState> pluginsToBeLinked = new ArrayList<SavedState>(20);
                this.readPluginsSavedStates(input, savedStates, pluginsToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                this.workspace.getSaveManager().setPluginsSavedState(savedStates);
                int treeIndex = pluginsToBeLinked.size();
                ArrayList<BuilderPersistentInfo> buildersToBeLinked = new ArrayList<BuilderPersistentInfo>(20);
                this.readBuildersPersistentInfo(null, input, buildersToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                ElementTree[] trees = this.readTrees(Path.ROOT, input, Policy.subMonitorFor(monitor, Policy.opWork * 40 / 100));
                this.linkPluginsSavedStateToTrees(pluginsToBeLinked, trees, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                this.linkBuildersToTrees(buildersToBeLinked, trees, treeIndex, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                if (input.available() > 0) {
                    buildersToBeLinked.clear();
                    this.readBuildersPersistentInfo(null, input, buildersToBeLinked, Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                    this.linkBuildersToTrees(buildersToBeLinked, trees, treeIndex += buildersToBeLinked.size(), Policy.subMonitorFor(monitor, Policy.opWork * 10 / 100));
                    for (BuilderPersistentInfo builderPersistentInfo : this.builderInfos) {
                        builderPersistentInfo.setConfigName(input.readUTF());
                    }
                }
                this.setBuilderInfos(this.builderInfos);
            }
            catch (IOException e) {
                String message = Messages.resources_readProjectTree;
                throw new ResourceException(567, null, message, e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void readTree(IProject project, DataInputStream input, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            try {
                String message = Messages.resources_reading;
                monitor.beginTask(message, 10);
                this.builderInfos = new ArrayList<BuilderPersistentInfo>(20);
                int treeIndex = 0;
                ArrayList<BuilderPersistentInfo> buildersToBeLinked = new ArrayList<BuilderPersistentInfo>(20);
                this.readBuildersPersistentInfo(project, input, buildersToBeLinked, Policy.subMonitorFor(monitor, 1));
                ElementTree[] trees = this.readTrees(project.getFullPath(), input, Policy.subMonitorFor(monitor, 8));
                this.linkBuildersToTrees(buildersToBeLinked, trees, treeIndex, Policy.subMonitorFor(monitor, 1));
                if (input.available() > 0) {
                    ArrayList<BuilderPersistentInfo> infos = new ArrayList<BuilderPersistentInfo>(5);
                    this.readBuildersPersistentInfo(project, input, infos, Policy.subMonitorFor(monitor, 1));
                    this.linkBuildersToTrees(infos, trees, treeIndex += buildersToBeLinked.size(), Policy.subMonitorFor(monitor, 1));
                    for (BuilderPersistentInfo builderPersistentInfo : this.builderInfos) {
                        builderPersistentInfo.setConfigName(input.readUTF());
                    }
                }
                this.setBuilderInfos(this.builderInfos);
            }
            catch (IOException e) {
                String message = Messages.resources_readProjectTree;
                throw new ResourceException(567, null, message, e);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void linkBuildersToTrees(List<BuilderPersistentInfo> buildersToBeLinked, ElementTree[] trees, int index, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            int i = 0;
            while (i < buildersToBeLinked.size()) {
                BuilderPersistentInfo info = buildersToBeLinked.get(i);
                info.setLastBuildTree(trees[index++]);
                this.builderInfos.add(info);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void setBuilderInfos(List<BuilderPersistentInfo> infos) {
        HashMap groupedInfos = new HashMap();
        for (BuilderPersistentInfo builderPersistentInfo : infos) {
            if (!groupedInfos.containsKey(builderPersistentInfo.getProjectName())) {
                groupedInfos.put(builderPersistentInfo.getProjectName(), new ArrayList());
            }
            ((List)groupedInfos.get(builderPersistentInfo.getProjectName())).add(builderPersistentInfo);
        }
        for (Map.Entry entry : groupedInfos.entrySet()) {
            IProject proj = this.workspace.getRoot().getProject((String)entry.getKey());
            this.workspace.getBuildManager().setBuildersPersistentInfo(proj, (List)entry.getValue());
        }
    }
}

