/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.core.runtime;

import org.greenrobot.eclipse.core.internal.runtime.Activator;
import org.greenrobot.eclipse.core.internal.runtime.CommonMessages;
import org.greenrobot.eclipse.core.internal.runtime.RuntimeLog;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.ISafeRunnable;
import org.greenrobot.eclipse.core.runtime.ISafeRunnableWithResult;
import org.greenrobot.eclipse.core.runtime.IStatus;
import org.greenrobot.eclipse.core.runtime.MultiStatus;
import org.greenrobot.eclipse.core.runtime.OperationCanceledException;
import org.greenrobot.eclipse.core.runtime.Status;
import org.greenrobot.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (AssertionError | Exception | LinkageError e) {
            SafeRunner.handleException(code, (Throwable)e);
        }
    }

    public static <T> T run(ISafeRunnableWithResult<T> code) {
        Assert.isNotNull(code);
        try {
            return code.runWithResult();
        }
        catch (AssertionError | Exception | LinkageError e) {
            SafeRunner.handleException(code, (Throwable)e);
            return null;
        }
    }

    private static void handleException(ISafeRunnable code, Throwable exception) {
        if (!(exception instanceof OperationCanceledException)) {
            String pluginId = SafeRunner.getBundleIdOfSafeRunnable(code);
            IStatus status = SafeRunner.convertToStatus(exception, pluginId);
            SafeRunner.makeSureUserSeesException(exception, status);
        }
        code.handleException(exception);
    }

    private static void makeSureUserSeesException(Throwable exception, IStatus status) {
        if (RuntimeLog.isEmpty()) {
            exception.printStackTrace();
        } else {
            RuntimeLog.log(status);
        }
    }

    private static String getBundleIdOfSafeRunnable(ISafeRunnable code) {
        Activator activator = Activator.getDefault();
        String pluginId = null;
        if (activator != null) {
            pluginId = activator.getBundleId(code);
        }
        if (pluginId == null) {
            return "org.greenrobot.eclipse.equinox.common";
        }
        return pluginId;
    }

    private static IStatus convertToStatus(Throwable exception, String pluginId) {
        String message = NLS.bind(CommonMessages.meta_pluginProblems, pluginId);
        if (exception instanceof CoreException) {
            MultiStatus status = new MultiStatus(pluginId, 2, message, exception);
            status.merge(((CoreException)exception).getStatus());
            return status;
        }
        return new Status(4, pluginId, 2, message, exception);
    }
}

