/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core;

import org.greenrobot.eclipse.jdt.core.IClassFile;
import org.greenrobot.eclipse.jdt.core.IMember;
import org.greenrobot.eclipse.jdt.core.IMethod;
import org.greenrobot.eclipse.jdt.core.ISourceRange;
import org.greenrobot.eclipse.jdt.core.IType;
import org.greenrobot.eclipse.jdt.core.ITypeParameter;
import org.greenrobot.eclipse.jdt.core.ITypeRoot;
import org.greenrobot.eclipse.jdt.core.JavaModelException;
import org.greenrobot.eclipse.jdt.core.Signature;
import org.greenrobot.eclipse.jdt.core.SourceRange;
import org.greenrobot.eclipse.jdt.core.compiler.CharOperation;
import org.greenrobot.eclipse.jdt.internal.core.BinaryMember;
import org.greenrobot.eclipse.jdt.internal.core.BinaryType;
import org.greenrobot.eclipse.jdt.internal.core.JavaElement;
import org.greenrobot.eclipse.jdt.internal.core.SourceMapper;
import org.greenrobot.eclipse.jdt.internal.core.SourceRefElement;
import org.greenrobot.eclipse.jdt.internal.core.TypeParameterElementInfo;

public class TypeParameter
extends SourceRefElement
implements ITypeParameter {
    static final ITypeParameter[] NO_TYPE_PARAMETERS = new ITypeParameter[0];
    protected String name;

    public TypeParameter(JavaElement parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TypeParameter)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String[] getBounds() throws JavaModelException {
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return CharOperation.toStrings(info.bounds);
    }

    @Override
    public String[] getBoundsSignatures() throws JavaModelException {
        String[] boundSignatures = null;
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        if (this.parent instanceof BinaryMember) {
            char[][] boundsSignatures = info.boundsSignatures;
            if (boundsSignatures == null || boundsSignatures.length == 0) {
                return CharOperation.NO_STRINGS;
            }
            return CharOperation.toStrings(info.boundsSignatures);
        }
        char[][] bounds = info.bounds;
        if (bounds == null || bounds.length == 0) {
            return CharOperation.NO_STRINGS;
        }
        int boundsLength = bounds.length;
        boundSignatures = new String[boundsLength];
        int i = 0;
        while (i < boundsLength) {
            boundSignatures[i] = new String(Signature.createCharArrayTypeSignature(bounds[i], false));
            ++i;
        }
        return boundSignatures;
    }

    @Override
    public IMember getDeclaringMember() {
        return (IMember)this.getParent();
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 15;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return ']';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        StringBuilder buf = new StringBuilder();
        if (this.parent instanceof IType) {
            if (this.parent instanceof BinaryType) {
                buf.append(((BinaryType)this.parent).getKey(forceOpen));
            } else {
                buf.append(((IType)((Object)this.parent)).getKey());
            }
        } else if (this.parent instanceof IMember) {
            if (this.parent instanceof BinaryMember) {
                buf.append(((BinaryMember)this.parent).getKey(forceOpen));
            } else {
                buf.append(((IMethod)((Object)this.parent)).getKey());
            }
        }
        buf.append(":T");
        buf.append(this.name);
        buf.append(';');
        return buf.toString();
    }

    @Override
    public ISourceRange getNameRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getNameRange(this);
        }
        TypeParameterElementInfo info = (TypeParameterElementInfo)this.getElementInfo();
        return new SourceRange(info.nameStart, info.nameEnd - info.nameStart + 1);
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IClassFile classFile;
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null && (classFile = this.getClassFile()) != null) {
            classFile.getBuffer();
            return mapper.getSourceRange(this);
        }
        return super.getSourceRange();
    }

    @Override
    public IClassFile getClassFile() {
        return ((JavaElement)this.getParent()).getClassFile();
    }

    @Override
    public ITypeRoot getTypeRoot() {
        return this.getDeclaringMember().getTypeRoot();
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        buffer.append('<');
        buffer.append(this.getElementName());
        buffer.append('>');
    }
}

