/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd;

import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.IndexException;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.RelatedAddress;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.IField;

public final class IndexExceptionBuilder {
    private final Database db;
    private final List<RelatedAddress> relatedAddresses = new ArrayList<RelatedAddress>();

    public IndexExceptionBuilder(Database db) {
        this.db = db;
    }

    public IndexExceptionBuilder addProblemAddress(String description, long dataBlockAddress, int rangeSize) {
        ModificationLog.MemoryAccessLog lastWrite = this.db.getLog().getReportFor(dataBlockAddress, rangeSize);
        this.relatedAddresses.add(new RelatedAddress(description, dataBlockAddress, rangeSize, lastWrite));
        return this;
    }

    public IndexExceptionBuilder addProblemAddress(String description, IField field, long address) {
        long offset = field.getOffset();
        int size = field.getRecordSize();
        return this.addProblemAddress(description, address + offset, size);
    }

    public IndexExceptionBuilder addProblemAddress(IField field, long address) {
        return this.addProblemAddress(field.getFieldName(), field, address);
    }

    public IndexException build(String description) {
        IndexException toThrow = new IndexException(description);
        if (this.db.getLog().enabled()) {
            toThrow.setTime(this.db.getLog().getWriteCount());
        }
        this.attachTo(toThrow);
        return toThrow;
    }

    public void attachTo(IndexException exception) {
        for (RelatedAddress next : this.relatedAddresses) {
            exception.addRelatedAddress(next);
        }
    }
}

