/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.field;

import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.greenrobot.eclipse.jdt.internal.core.nd.Nd;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.BaseField;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldShort;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.StructDef;
import org.greenrobot.eclipse.jdt.internal.core.nd.util.MathUtils;

public class FieldList<T>
extends BaseField
implements IDestructableField {
    public static final FieldPointer FIRST_BLOCK;
    public static final FieldPointer LAST_BLOCK_WITH_ELEMENTS;
    private static final StructDef<FieldList> type;
    private static final int LIST_HEADER_BYTES;
    private static final long MAX_BYTES_IN_A_CHUNK;
    private final StructDef<T> elementType;
    private final int elementsPerBlock;
    private final StructDef<?> ownerType;
    private final ModificationLog.Tag allocateTag;
    private final ModificationLog.Tag appendTag;
    private final ModificationLog.Tag destructTag;

    static {
        MAX_BYTES_IN_A_CHUNK = Database.getBytesThatFitInChunks(1);
        type = StructDef.createAbstract(FieldList.class);
        FIRST_BLOCK = type.addPointer();
        LAST_BLOCK_WITH_ELEMENTS = type.addPointer();
        type.done();
        LIST_HEADER_BYTES = MathUtils.roundUpToNearestMultipleOfPowerOfTwo(type.size(), 8);
    }

    private FieldList(StructDef<?> ownerType, StructDef<T> elementType, int elementsPerBlock) {
        this.elementType = elementType;
        this.elementsPerBlock = elementsPerBlock;
        this.ownerType = ownerType;
        int fieldNumber = ownerType.getNumFields();
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + ownerType.getStructName());
        this.allocateTag = ModificationLog.createTag("Allocating elements for " + this.getFieldName());
        this.appendTag = ModificationLog.createTag("Appending to " + this.getFieldName());
        this.destructTag = ModificationLog.createTag("Deallocating " + this.getFieldName());
    }

    public static <T> FieldList<T> create(StructDef<?> ownerStruct, StructDef<T> elementType) {
        return FieldList.create(ownerStruct, elementType, 1);
    }

    public static <T> FieldList<T> create(StructDef<?> ownerStruct, StructDef<T> elementType, int elementsPerBlock) {
        FieldList<T> result = new FieldList<T>(ownerStruct, elementType, elementsPerBlock);
        ownerStruct.add(result);
        ownerStruct.addDestructableField(result);
        return result;
    }

    private int getElementSize() {
        int recordSize = this.elementType.getFactory().getRecordSize();
        return MathUtils.roundUpToNearestMultipleOfPowerOfTwo(recordSize, 8);
    }

    @Override
    public int getRecordSize() {
        return LIST_HEADER_BYTES;
    }

    public List<T> asList(Nd nd, long address) {
        long headerStartAddress = address + (long)this.offset;
        long firstBlockAddress = FIRST_BLOCK.get(nd, headerStartAddress);
        ArrayList result = new ArrayList();
        long nextBlockAddress = firstBlockAddress;
        while (nextBlockAddress != 0L) {
            long currentBlockAddress = nextBlockAddress;
            nextBlockAddress = BlockHeader.NEXT_BLOCK.get(nd, currentBlockAddress);
            short elementsInBlock = BlockHeader.ELEMENTS_IN_USE.get(nd, currentBlockAddress);
            long firstElementInBlockAddress = currentBlockAddress + (long)BlockHeader.BLOCK_HEADER_BYTES;
            this.readElements(result, nd, firstElementInBlockAddress, elementsInBlock);
        }
        return result;
    }

    private void readElements(List<T> result, Nd nd, long nextElementAddress, int count) {
        ITypeFactory<T> factory = this.elementType.getFactory();
        int size = this.getElementSize();
        while (count > 0) {
            result.add(factory.create(nd, nextElementAddress));
            nextElementAddress += (long)size;
            --count;
        }
    }

    public T append(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.appendTag);
        try {
            short blockSize;
            short elementsInBlock;
            long nextBlockAddress;
            long headerStartAddress = address + (long)this.offset;
            long insertionBlockAddress = nextBlockAddress = LAST_BLOCK_WITH_ELEMENTS.get(nd, headerStartAddress);
            if (nextBlockAddress == 0L) {
                long newBlockAddress = this.allocateNewBlock(nd, this.elementsPerBlock);
                LAST_BLOCK_WITH_ELEMENTS.put(nd, headerStartAddress, newBlockAddress);
                FIRST_BLOCK.put(nd, headerStartAddress, newBlockAddress);
                insertionBlockAddress = newBlockAddress;
            }
            if ((elementsInBlock = BlockHeader.ELEMENTS_IN_USE.get(nd, insertionBlockAddress)) >= (blockSize = BlockHeader.BLOCK_SIZE.get(nd, insertionBlockAddress))) {
                long nextBlock = BlockHeader.NEXT_BLOCK.get(nd, insertionBlockAddress);
                if (nextBlock == 0L) {
                    nextBlock = this.allocateNewBlock(nd, this.elementsPerBlock);
                    BlockHeader.NEXT_BLOCK.put(nd, insertionBlockAddress, nextBlock);
                }
                LAST_BLOCK_WITH_ELEMENTS.put(nd, headerStartAddress, nextBlock);
                insertionBlockAddress = nextBlock;
                elementsInBlock = BlockHeader.ELEMENTS_IN_USE.get(nd, insertionBlockAddress);
            }
            BlockHeader.ELEMENTS_IN_USE.put(nd, insertionBlockAddress, (short)(elementsInBlock + 1));
            int elementSize = this.getElementSize();
            long resultAddress = insertionBlockAddress + (long)BlockHeader.BLOCK_HEADER_BYTES + (long)(elementsInBlock * elementSize);
            assert ((resultAddress - 2L & 7L) == 0L);
            T t = this.elementType.getFactory().create(nd, resultAddress);
            return t;
        }
        finally {
            db.getLog().end(this.appendTag);
        }
    }

    public void allocate(Nd nd, long address, int numElements) {
        Database db = nd.getDB();
        db.getLog().start(this.allocateTag);
        try {
            if (numElements == 0) {
                return;
            }
            long headerStartAddress = address + (long)this.offset;
            long nextBlockAddress = LAST_BLOCK_WITH_ELEMENTS.get(nd, headerStartAddress);
            int maxBlockSizeThatFitsInAChunk = (int)((MAX_BYTES_IN_A_CHUNK - (long)BlockHeader.BLOCK_HEADER_BYTES) / (long)this.getElementSize());
            if (nextBlockAddress == 0L) {
                int firstAllocation = Math.min(numElements, maxBlockSizeThatFitsInAChunk);
                nextBlockAddress = this.allocateNewBlock(nd, firstAllocation);
                LAST_BLOCK_WITH_ELEMENTS.put(nd, headerStartAddress, nextBlockAddress);
                FIRST_BLOCK.put(nd, headerStartAddress, nextBlockAddress);
            }
            int remainingToAllocate = numElements;
            while (true) {
                long currentBlockAddress = nextBlockAddress;
                nextBlockAddress = BlockHeader.NEXT_BLOCK.get(nd, currentBlockAddress);
                short elementsInUse = BlockHeader.ELEMENTS_IN_USE.get(nd, currentBlockAddress);
                short blockSize = BlockHeader.BLOCK_SIZE.get(nd, currentBlockAddress);
                if ((remainingToAllocate -= blockSize - elementsInUse) <= 0) {
                    break;
                }
                if (nextBlockAddress != 0L) continue;
                nextBlockAddress = this.allocateNewBlock(nd, Math.min(maxBlockSizeThatFitsInAChunk, numElements));
                BlockHeader.NEXT_BLOCK.put(nd, currentBlockAddress, nextBlockAddress);
            }
        }
        finally {
            db.getLog().end(this.allocateTag);
        }
    }

    private long allocateNewBlock(Nd nd, int blockSize) {
        short poolId = this.getMemoryPoolId(nd);
        int elementSize = this.getElementSize();
        long bytesNeeded = BlockHeader.BLOCK_HEADER_BYTES + blockSize * elementSize;
        if (MAX_BYTES_IN_A_CHUNK - bytesNeeded < (long)elementSize) {
            bytesNeeded = MAX_BYTES_IN_A_CHUNK;
        }
        long result = nd.getDB().malloc(bytesNeeded, poolId);
        BlockHeader.BLOCK_SIZE.put(nd, result, (short)blockSize);
        return result;
    }

    private short getMemoryPoolId(Nd nd) {
        short poolId = 5;
        if (this.ownerType != null) {
            Class<?> structClass = this.ownerType.getStructClass();
            if (nd.getTypeRegistry().isRegisteredClass(structClass)) {
                poolId = (short)(256 + nd.getNodeType(structClass));
            }
        }
        return poolId;
    }

    @Override
    public void destruct(Nd nd, long address) {
        Database db = nd.getDB();
        db.getLog().start(this.destructTag);
        try {
            long firstBlockAddress;
            short poolId = this.getMemoryPoolId(nd);
            long headerStartAddress = address + (long)this.offset;
            long nextBlockAddress = firstBlockAddress = FIRST_BLOCK.get(nd, headerStartAddress);
            while (nextBlockAddress != 0L) {
                long currentBlockAddress = nextBlockAddress;
                nextBlockAddress = BlockHeader.NEXT_BLOCK.get(nd, currentBlockAddress);
                short elementsInBlock = BlockHeader.ELEMENTS_IN_USE.get(nd, currentBlockAddress);
                this.destructElements(nd, currentBlockAddress + (long)BlockHeader.BLOCK_HEADER_BYTES, elementsInBlock);
                db.free(currentBlockAddress, poolId);
            }
            db.clearRange(headerStartAddress, this.getRecordSize());
        }
        finally {
            db.getLog().end(this.destructTag);
        }
    }

    private void destructElements(Nd nd, long nextElementAddress, int count) {
        ITypeFactory<T> factory = this.elementType.getFactory();
        int size = this.getElementSize();
        while (--count >= 0) {
            factory.destruct(nd, nextElementAddress);
            nextElementAddress += (long)size;
        }
    }

    private static class BlockHeader {
        public static final FieldPointer NEXT_BLOCK;
        public static final FieldShort BLOCK_SIZE;
        public static final FieldShort ELEMENTS_IN_USE;
        public static final int BLOCK_HEADER_BYTES;
        private static final StructDef<BlockHeader> type;

        static {
            type = StructDef.createAbstract(BlockHeader.class);
            NEXT_BLOCK = type.addPointer();
            BLOCK_SIZE = type.addShort();
            ELEMENTS_IN_USE = type.addShort();
            type.done();
            BLOCK_HEADER_BYTES = MathUtils.roundUpToNearestMultipleOfPowerOfTwo(type.size(), 8);
        }

        private BlockHeader() {
        }
    }
}

