/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.indexer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.greenrobot.eclipse.core.resources.IContainer;
import org.greenrobot.eclipse.core.resources.IFile;
import org.greenrobot.eclipse.core.resources.IProject;
import org.greenrobot.eclipse.core.resources.IResource;
import org.greenrobot.eclipse.core.resources.IWorkspaceRoot;
import org.greenrobot.eclipse.core.runtime.CoreException;
import org.greenrobot.eclipse.core.runtime.IPath;
import org.greenrobot.eclipse.core.runtime.IProgressMonitor;
import org.greenrobot.eclipse.core.runtime.Path;
import org.greenrobot.eclipse.core.runtime.SubMonitor;
import org.greenrobot.eclipse.jdt.core.IClassFile;
import org.greenrobot.eclipse.jdt.core.IClasspathEntry;
import org.greenrobot.eclipse.jdt.core.IJavaElement;
import org.greenrobot.eclipse.jdt.core.IJavaProject;
import org.greenrobot.eclipse.jdt.core.IPackageFragmentRoot;
import org.greenrobot.eclipse.jdt.core.IParent;
import org.greenrobot.eclipse.jdt.core.JavaCore;
import org.greenrobot.eclipse.jdt.internal.core.nd.indexer.Package;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.JavaIndex;

public final class WorkspaceSnapshot {
    private Map<IPath, List<IJavaElement>> allIndexables;
    public static boolean EXPERIMENTAL_INDEX_OUTPUT_FOLDERS;

    private WorkspaceSnapshot(Map<IPath, List<IJavaElement>> allIndexables) {
        this.allIndexables = allIndexables;
    }

    public Map<IPath, List<IJavaElement>> getAllIndexables() {
        return this.allIndexables;
    }

    public Set<IPath> allLocations() {
        return this.allIndexables.keySet();
    }

    public List<IJavaElement> get(IPath next) {
        List<IJavaElement> result = this.allIndexables.get(next);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public static WorkspaceSnapshot create(IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert(monitor);
        List<IJavaElement> unfilteredIndexables = WorkspaceSnapshot.getAllIndexableObjectsInWorkspace(root, subMonitor.split(3));
        Map<IPath, List<IJavaElement>> allIndexables = WorkspaceSnapshot.removeDuplicatePaths(unfilteredIndexables);
        return new WorkspaceSnapshot(allIndexables);
    }

    private static IPath getWorkspacePathForRoot(IJavaElement next) {
        IResource resource = next.getResource();
        if (resource != null) {
            return resource.getFullPath();
        }
        return Path.EMPTY;
    }

    private static Map<IPath, List<IJavaElement>> removeDuplicatePaths(List<IJavaElement> allIndexables) {
        HashMap<IPath, List<IJavaElement>> paths = new HashMap<IPath, List<IJavaElement>>();
        HashSet<IPath> workspacePaths = new HashSet<IPath>();
        for (IJavaElement next : allIndexables) {
            IPath nextPath = JavaIndex.getLocationForElement(next);
            IPath workspacePath = WorkspaceSnapshot.getWorkspacePathForRoot(next);
            ArrayList<IJavaElement> value = (ArrayList<IJavaElement>)paths.get(nextPath);
            if (value == null) {
                value = new ArrayList<IJavaElement>();
                paths.put(nextPath, value);
            } else if (workspacePath != null) {
                if (workspacePaths.contains(workspacePath)) continue;
                if (!workspacePath.isEmpty()) {
                    Package.logInfo("Found duplicate workspace path for " + workspacePath.toString());
                }
                workspacePaths.add(workspacePath);
            }
            value.add(next);
        }
        return paths;
    }

    private static List<IJavaElement> getAllIndexableObjectsInWorkspace(IWorkspaceRoot root, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert(monitor, 2);
        ArrayList<IJavaElement> allIndexables = new ArrayList<IJavaElement>();
        IProject[] projects = root.getProjects();
        ArrayList<IProject> projectsToScan = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (next.isOpen()) {
                projectsToScan.add(next);
            }
            ++n2;
        }
        HashSet<IPath> scannedPaths = new HashSet<IPath>();
        HashSet<IResource> resourcesToScan = new HashSet<IResource>();
        SubMonitor projectLoopMonitor = subMonitor.split(1).setWorkRemaining(projectsToScan.size());
        for (IProject project : projectsToScan) {
            SubMonitor iterationMonitor = projectLoopMonitor.split(1);
            try {
                int n3;
                if (!project.isOpen() || !project.isNatureEnabled("org.greenrobot.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create(project);
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                if (EXPERIMENTAL_INDEX_OUTPUT_FOLDERS) {
                    IPath defaultOutputLocation = javaProject.getOutputLocation();
                    IClasspathEntry[] iClasspathEntryArray = entries;
                    n3 = entries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource;
                        IClasspathEntry next = iClasspathEntryArray[n4];
                        IPath nextOutputLocation = next.getOutputLocation();
                        if (nextOutputLocation == null) {
                            nextOutputLocation = defaultOutputLocation;
                        }
                        if ((resource = root.findMember(nextOutputLocation)) != null) {
                            resourcesToScan.add(resource);
                        }
                        ++n4;
                    }
                }
                IPackageFragmentRoot[] projectRoots = javaProject.getAllPackageFragmentRoots();
                SubMonitor rootLoopMonitor = iterationMonitor.setWorkRemaining(projectRoots.length);
                IPackageFragmentRoot[] iPackageFragmentRootArray = projectRoots;
                int n5 = projectRoots.length;
                n3 = 0;
                while (n3 < n5) {
                    IPath filesystemPath;
                    IPackageFragmentRoot nextRoot = iPackageFragmentRootArray[n3];
                    rootLoopMonitor.split(1);
                    if (nextRoot.exists() && !scannedPaths.contains(filesystemPath = JavaIndex.getLocationForElement(nextRoot))) {
                        scannedPaths.add(filesystemPath);
                        if (nextRoot.getKind() == 2) {
                            if (nextRoot.isArchive()) {
                                allIndexables.add(nextRoot);
                            } else {
                                WorkspaceSnapshot.collectAllClassFiles(root, allIndexables, nextRoot);
                            }
                        } else {
                            WorkspaceSnapshot.collectAllClassFiles(root, allIndexables, nextRoot);
                        }
                    }
                    ++n3;
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
        }
        WorkspaceSnapshot.collectAllClassFiles(root, allIndexables, resourcesToScan, subMonitor.split(1));
        return allIndexables;
    }

    private static void collectAllClassFiles(IWorkspaceRoot root, List<? super IClassFile> result, Collection<? extends IResource> toScan, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert(monitor);
        ArrayDeque<? extends IResource> resources = new ArrayDeque<IResource>();
        resources.addAll(toScan);
        while (!resources.isEmpty()) {
            IJavaElement element;
            IFile file;
            String extension;
            subMonitor.setWorkRemaining(Math.max(resources.size(), 3000)).split(1);
            IResource next = (IResource)resources.removeFirst();
            if (next instanceof IContainer) {
                IContainer container = (IContainer)next;
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource nextChild = iResourceArray[n2];
                        resources.addLast(nextChild);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    Package.log(e);
                }
                continue;
            }
            if (!(next instanceof IFile) || !Objects.equals(extension = (file = (IFile)next).getFileExtension(), "class") || !((element = JavaCore.create(file)) instanceof IClassFile)) continue;
            result.add((IClassFile)element);
        }
    }

    private static void collectAllClassFiles(IWorkspaceRoot root, List<? super IClassFile> result, IParent nextRoot) throws CoreException {
        IJavaElement[] iJavaElementArray = nextRoot.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            try {
                int type = child.getElementType();
                if (type != 5 && child.exists()) {
                    if (type == 6) {
                        result.add((IClassFile)child);
                    } else if (child instanceof IParent) {
                        IParent parent = (IParent)((Object)child);
                        WorkspaceSnapshot.collectAllClassFiles(root, result, parent);
                    }
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
            ++n2;
        }
    }
}

