/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.java;

import org.greenrobot.eclipse.jdt.internal.core.nd.IDestructable;
import org.greenrobot.eclipse.jdt.internal.core.nd.Nd;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.FieldPointer;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.StructDef;
import org.greenrobot.eclipse.jdt.internal.core.nd.java.NdAnnotation;

public class NdTypeAnnotation
extends NdAnnotation
implements IDestructable {
    public static final FieldByte TARGET_TYPE;
    public static final FieldByte TARGET_ARG0;
    public static final FieldByte TARGET_ARG1;
    public static final FieldByte PATH_LENGTH;
    public static final FieldPointer PATH;
    public static final StructDef<NdTypeAnnotation> type;
    private static final byte[] NO_TYPE_PATH;

    static {
        type = StructDef.create(NdTypeAnnotation.class, NdAnnotation.type);
        TARGET_TYPE = type.addByte();
        TARGET_ARG0 = type.addByte();
        TARGET_ARG1 = type.addByte();
        PATH_LENGTH = type.addByte();
        PATH = type.addPointer();
        type.done();
        NO_TYPE_PATH = new byte[0];
    }

    public NdTypeAnnotation(Nd nd, long address) {
        super(nd, address);
    }

    public void setPath(byte[] path) {
        this.freePath();
        PATH_LENGTH.put(this.nd, this.address, (byte)path.length);
        if (path.length > 0) {
            long pathArray = this.nd.getDB().malloc(path.length, (short)0);
            PATH.put(this.nd, this.address, pathArray);
            this.nd.getDB().putBytes(pathArray, path, path.length);
        }
    }

    public void setTargetInfo(int arg) {
        TARGET_ARG0.put(this.getNd(), this.address, (byte)(arg >> 8 & 0xFF));
        TARGET_ARG1.put(this.getNd(), this.address, (byte)(arg & 0xFF));
    }

    public byte getTargetInfoArg0() {
        return TARGET_ARG0.get(this.getNd(), this.address);
    }

    public byte getTargetInfoArg1() {
        return TARGET_ARG1.get(this.getNd(), this.address);
    }

    public int getTarget() {
        int arg0 = TARGET_ARG0.get(this.getNd(), this.address) & 0xFF;
        int arg1 = TARGET_ARG1.get(this.getNd(), this.address) & 0xFF;
        int result = arg0 << 8 | arg1;
        return result;
    }

    public void setTargetInfo(byte arg0, byte arg1) {
        TARGET_ARG0.put(this.getNd(), this.address, arg0);
        TARGET_ARG1.put(this.getNd(), this.address, arg1);
    }

    public void setTargetType(int targetType) {
        TARGET_TYPE.put(this.getNd(), this.address, (byte)targetType);
    }

    public int getTargetType() {
        return TARGET_TYPE.get(this.getNd(), this.address);
    }

    public byte[] getTypePath() {
        long pathPointer = PATH.get(this.getNd(), this.address);
        if (pathPointer == 0L) {
            return NO_TYPE_PATH;
        }
        byte pathLength = PATH_LENGTH.get(this.getNd(), this.address);
        byte[] result = new byte[pathLength];
        this.getNd().getDB().getBytes(pathPointer, result);
        return result;
    }

    @Override
    public void destruct() {
        this.freePath();
    }

    private void freePath() {
        long pathPointer = PATH.get(this.nd, this.address);
        this.nd.getDB().free(pathPointer, (short)0);
    }
}

